/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MICommandCache
implements ICommandListener {
    private ICommandControl fConnection;
    private boolean fIsTargetAvailable = true;
    private int fResetCounter = 0;
    private Map<IDMContext, HashMap<CommandInfo, ICommandResult>> fCachedContexts = new HashMap<IDMContext, HashMap<CommandInfo, ICommandResult>>();
    private ArrayList<CommandInfo> fPendingQCommandsSent = new ArrayList();
    private ArrayList<CommandInfo> fPendingQCommandsNotYetSent = new ArrayList();
    private ArrayList<CommandInfo> fPendingQWaitingForCoalescedCompletion = new ArrayList();

    public MICommandCache(ICommandControl connection) {
        this.fConnection = connection;
        connection.addCommandListener((ICommandListener)this);
    }

    private CommandInfo getCoalescedCommand(CommandInfo cmd) {
        for (CommandInfo currentUnsentEntry : new ArrayList<CommandInfo>(this.fPendingQCommandsNotYetSent)) {
            ICommand<ICommandResult> unsentCommand = currentUnsentEntry.getCommand();
            ICommand coalescedCmd = unsentCommand.coalesceWith(cmd.getCommand());
            if (coalescedCmd == null) continue;
            CommandInfo coalescedCmdInfo = new CommandInfo(CommandStyle.COALESCED, (ICommand<ICommandResult>)coalescedCmd, null);
            if (currentUnsentEntry.getCommandstyle() == CommandStyle.COALESCED) {
                for (CommandInfo waitingEntry : new ArrayList<CommandInfo>(this.fPendingQWaitingForCoalescedCompletion)) {
                    if (waitingEntry.getCoalescedCmd() != currentUnsentEntry) continue;
                    waitingEntry.setCoalescedCmd(coalescedCmdInfo);
                }
            } else {
                this.fPendingQWaitingForCoalescedCompletion.add(currentUnsentEntry);
                currentUnsentEntry.setCoalescedCmd(coalescedCmdInfo);
            }
            this.fPendingQCommandsNotYetSent.remove(currentUnsentEntry);
            this.fConnection.removeCommand(unsentCommand);
            return coalescedCmdInfo;
        }
        return null;
    }

    public <V extends ICommandResult> void execute(ICommand<V> command, DataRequestMonitor<V> rm) {
        assert (this.fConnection.getExecutor().isInExecutorThread());
        ICommand<V> genericCommand = command;
        DataRequestMonitor<V> genericDone = rm;
        CommandInfo cachedCmd = new CommandInfo(CommandStyle.NONCOALESCED, genericCommand, genericDone);
        final IDMContext context = genericCommand.getContext();
        if (this.fCachedContexts.get(context) != null && this.fCachedContexts.get(context).containsKey(cachedCmd)) {
            ICommandResult v = this.fCachedContexts.get(context).get(cachedCmd);
            rm.setData((Object)v);
            rm.done();
            return;
        }
        if (!this.fIsTargetAvailable) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Target not available.", null));
            rm.done();
            return;
        }
        for (CommandInfo sentCommand : this.fPendingQCommandsSent) {
            if (!sentCommand.equals(cachedCmd)) continue;
            sentCommand.getRequestMonitorList().add(genericDone);
            return;
        }
        CommandInfo coalescedCmd = this.getCoalescedCommand(cachedCmd);
        if (coalescedCmd != null) {
            this.fPendingQWaitingForCoalescedCompletion.add(cachedCmd);
            cachedCmd.setCoalescedCmd(coalescedCmd);
            cachedCmd = coalescedCmd;
        }
        final CommandInfo finalCachedCmd = cachedCmd;
        this.fPendingQCommandsNotYetSent.add(finalCachedCmd);
        this.fConnection.queueCommand(finalCachedCmd.getCommand(), (DataRequestMonitor)new DataRequestMonitor<ICommandResult>((Executor)this.fConnection.getExecutor(), null){

            public void handleCompleted() {
                if (!MICommandCache.this.fPendingQCommandsSent.remove(finalCachedCmd)) {
                    return;
                }
                if (finalCachedCmd.getCommandstyle() == CommandStyle.COALESCED) {
                    ICommandResult result = (ICommandResult)this.getData();
                    for (CommandInfo waitingEntry : new ArrayList(MICommandCache.this.fPendingQWaitingForCoalescedCompletion)) {
                        if (waitingEntry.getCoalescedCmd() != finalCachedCmd) continue;
                        MICommandCache.this.fPendingQWaitingForCoalescedCompletion.remove(waitingEntry);
                        ICommandResult newresult = result.getSubsetResult(waitingEntry.getCommand());
                        if (MICommandCache.this.fCachedContexts.get(context) != null) {
                            ((HashMap)MICommandCache.this.fCachedContexts.get(context)).put(waitingEntry, newresult);
                        } else {
                            HashMap<CommandInfo, ICommandResult> map = new HashMap<CommandInfo, ICommandResult>();
                            map.put(waitingEntry, newresult);
                            MICommandCache.this.fCachedContexts.put(context, map);
                        }
                        if (!this.getStatus().isOK()) {
                            for (DataRequestMonitor<ICommandResult> pendingRM : waitingEntry.getRequestMonitorList()) {
                                pendingRM.setStatus(this.getStatus());
                                pendingRM.done();
                            }
                            continue;
                        }
                        assert (newresult != null);
                        Iterator<DataRequestMonitor<ICommandResult>> i$ = waitingEntry.getRequestMonitorList().iterator();
                        while (i$.hasNext()) {
                            DataRequestMonitor<ICommandResult> pendingRM;
                            DataRequestMonitor<ICommandResult> vPendingRM = pendingRM = i$.next();
                            vPendingRM.setData((Object)newresult);
                            vPendingRM.done();
                        }
                    }
                } else if (!this.getStatus().isOK()) {
                    for (DataRequestMonitor<ICommandResult> pendingRM : finalCachedCmd.getRequestMonitorList()) {
                        pendingRM.setStatus(this.getStatus());
                        pendingRM.done();
                    }
                } else {
                    ICommandResult result = (ICommandResult)this.getData();
                    if (MICommandCache.this.fCachedContexts.get(context) != null) {
                        ((HashMap)MICommandCache.this.fCachedContexts.get(context)).put(finalCachedCmd, result);
                    } else {
                        HashMap<CommandInfo, ICommandResult> map = new HashMap<CommandInfo, ICommandResult>();
                        map.put(finalCachedCmd, result);
                        MICommandCache.this.fCachedContexts.put(context, map);
                    }
                    Iterator<DataRequestMonitor<ICommandResult>> i$ = finalCachedCmd.getRequestMonitorList().iterator();
                    while (i$.hasNext()) {
                        DataRequestMonitor<ICommandResult> pendingRM;
                        DataRequestMonitor<ICommandResult> vPendingRM = pendingRM = i$.next();
                        vPendingRM.setData((Object)result);
                        vPendingRM.done();
                    }
                }
            }
        });
    }

    public void setTargetAvailable(boolean isAvailable) {
        this.fIsTargetAvailable = isAvailable;
    }

    public boolean isTargetAvailable() {
        return this.fIsTargetAvailable;
    }

    public void reset() {
        this.fCachedContexts.clear();
        ++this.fResetCounter;
    }

    public void commandRemoved(ICommand<? extends ICommandResult> command) {
    }

    public void commandQueued(ICommand<? extends ICommandResult> command) {
    }

    public void commandDone(ICommand<? extends ICommandResult> command, ICommandResult result) {
    }

    public void commandSent(ICommand<? extends ICommandResult> command) {
        ICommand<? extends ICommandResult> genericCommand = command;
        CommandInfo cachedCmd = new CommandInfo(CommandStyle.NONCOALESCED, genericCommand, null);
        for (CommandInfo unqueuedCommand : new ArrayList<CommandInfo>(this.fPendingQCommandsNotYetSent)) {
            if (!unqueuedCommand.equals(cachedCmd)) continue;
            this.fPendingQCommandsNotYetSent.remove(unqueuedCommand);
            this.fPendingQCommandsSent.add(unqueuedCommand);
            break;
        }
    }

    public void reset(IDMContext dmc) {
        if (dmc == null) {
            this.fCachedContexts.clear();
        }
        Iterator<IDMContext> itr = this.fCachedContexts.keySet().iterator();
        while (itr.hasNext()) {
            IDMContext keyDmc = itr.next();
            if (keyDmc == null || !DMContexts.isAncestorOf((IDMContext)keyDmc, (IDMContext)dmc)) continue;
            itr.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CommandInfo {
        List<DataRequestMonitor<ICommandResult>> fCurrentRequestMonitors;
        ICommand<ICommandResult> fCommand;
        CommandStyle fCmdStyle;
        CommandInfo fCoalescedCmd;
        int fResetCounterStatus;

        public CommandInfo(CommandStyle cmdstyle, ICommand<ICommandResult> cmd, DataRequestMonitor<ICommandResult> rm) {
            this.fCmdStyle = cmdstyle;
            this.fCommand = cmd;
            this.fCurrentRequestMonitors = new LinkedList<DataRequestMonitor<ICommandResult>>();
            this.fCurrentRequestMonitors.add(rm);
            this.fCoalescedCmd = null;
            this.fResetCounterStatus = MICommandCache.this.fResetCounter;
        }

        public CommandStyle getCommandstyle() {
            return this.fCmdStyle;
        }

        public List<DataRequestMonitor<ICommandResult>> getRequestMonitorList() {
            return this.fCurrentRequestMonitors;
        }

        public ICommand<ICommandResult> getCommand() {
            return this.fCommand;
        }

        public CommandInfo getCoalescedCmd() {
            return this.fCoalescedCmd;
        }

        public void setCoalescedCmd(CommandInfo cmd) {
            this.fCoalescedCmd = cmd;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CommandInfo)) {
                return false;
            }
            CommandInfo otherCmd = (CommandInfo)other;
            return otherCmd.fCommand.equals(this.fCommand);
        }

        public int hashCode() {
            return this.fCommand.hashCode() + (this.fResetCounterStatus + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CommandStyle {
        COALESCED,
        NONCOALESCED;

    }
}

