/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class DsfMIPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.dsdp.debug.gdb.core";
    public static boolean DEBUG = false;
    private static DsfMIPlugin fgPlugin;
    private static BundleContext fgBundleContext;

    public DsfMIPlugin() {
        fgPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        fgBundleContext = context;
        super.start(context);
        DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.dd.dsf.mi.core/debug"));
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        fgBundleContext = null;
    }

    public static DsfMIPlugin getDefault() {
        return fgPlugin;
    }

    public static BundleContext getBundleContext() {
        return fgBundleContext;
    }

    public static void debug(String message) {
        if (DEBUG) {
            System.out.print(message);
        }
    }

    public static String getDebugTime() {
        StringBuilder traceBuilder = new StringBuilder();
        long time = System.currentTimeMillis();
        long seconds = time / 1000L % 1000L;
        if (seconds < 100L) {
            traceBuilder.append('0');
        }
        if (seconds < 10L) {
            traceBuilder.append('0');
        }
        traceBuilder.append(seconds);
        traceBuilder.append(',');
        long millis = time % 1000L;
        if (millis < 100L) {
            traceBuilder.append('0');
        }
        if (millis < 10L) {
            traceBuilder.append('0');
        }
        traceBuilder.append(millis);
        return traceBuilder.toString();
    }
}

