/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.command;

import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.mi.core.command.DsfMICommand;
import org.eclipse.dd.dsf.mi.core.output.DsfMIDataListRegisterValuesInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.service.IMIExecutionDMContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfMIDataListRegisterValues
extends DsfMICommand<DsfMIDataListRegisterValuesInfo> {
    int[] regnums;
    int fFmt;

    public DsfMIDataListRegisterValues(IMIExecutionDMContext ctx, int fmt) {
        this(ctx, fmt, null);
    }

    public DsfMIDataListRegisterValues(IMIExecutionDMContext ctx, int fmt, int[] regnos) {
        super((IDMContext)ctx, "-data-list-register-values");
        this.regnums = regnos;
        String format = "x";
        switch (fmt) {
            case 5: {
                format = "N";
                break;
            }
            case 4: {
                format = "r";
                break;
            }
            case 3: {
                format = "d";
                break;
            }
            case 2: {
                format = "t";
                break;
            }
            case 1: {
                format = "o";
                break;
            }
            case 0: {
                format = "x";
                break;
            }
            default: {
                format = "x";
            }
        }
        this.fFmt = fmt;
        this.setOptions(new String[]{format});
        if (regnos != null && regnos.length > 0) {
            String[] array = new String[regnos.length];
            for (int i = 0; i < regnos.length; ++i) {
                array[i] = Integer.toString(regnos[i]);
            }
            this.setParameters(array);
        }
    }

    public int[] getRegList() {
        return this.regnums;
    }

    @Override
    public DsfMIDataListRegisterValuesInfo getResult(DsfMIOutput output) {
        return new DsfMIDataListRegisterValuesInfo(output);
    }

    public DsfMIDataListRegisterValues coalesceWith(ICommand<? extends ICommandResult> command) {
        if (!(command instanceof DsfMIDataListRegisterValues)) {
            return null;
        }
        DsfMIDataListRegisterValues cmd = (DsfMIDataListRegisterValues)command;
        int[] newregnos = new int[this.regnums.length + cmd.regnums.length];
        for (int idx = 0; idx < this.regnums.length; ++idx) {
            newregnos[idx] = this.regnums[idx];
        }
        int curloc = this.regnums.length;
        for (int ndx = 0; ndx < cmd.regnums.length; ++ndx) {
            int ldx;
            int curnum = cmd.regnums[ndx];
            for (ldx = 0; ldx < this.regnums.length && newregnos[ldx] != curnum; ++ldx) {
            }
            if (ldx != this.regnums.length) continue;
            newregnos[curloc] = curnum;
            ++curloc;
        }
        int[] finalregnums = new int[curloc];
        for (int fdx = 0; fdx < curloc; ++fdx) {
            finalregnums[fdx] = newregnos[fdx];
        }
        return new DsfMIDataListRegisterValues((IMIExecutionDMContext)this.getContext(), this.fFmt, finalregnums);
    }
}

