/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.dsf.mi.core.output.DsfMIBreakpoint;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfMIBreakListInfo
extends DsfMIInfo {
    DsfMIBreakpoint[] breakpoints;

    public DsfMIBreakListInfo(DsfMIOutput rr) {
        super(rr);
    }

    public DsfMIBreakpoint[] getMIBreakpoints() {
        if (this.breakpoints == null) {
            this.parse();
        }
        return this.breakpoints;
    }

    void parse() {
        DsfMIOutput out;
        DsfMIResultRecord rr;
        ArrayList<DsfMIBreakpoint> aList = new ArrayList<DsfMIBreakpoint>(1);
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            DsfMIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                if (!var.equals("BreakpointTable")) continue;
                this.parseTable(results[i].getMIValue(), aList);
            }
        }
        this.breakpoints = aList.toArray(new DsfMIBreakpoint[aList.size()]);
    }

    void parseTable(DsfMIValue val, List<DsfMIBreakpoint> aList) {
        if (val instanceof DsfMITuple) {
            DsfMIResult[] table = ((DsfMITuple)val).getMIResults();
            for (int j = 0; j < table.length; ++j) {
                String variable = table[j].getVariable();
                if (!variable.equals("body")) continue;
                this.parseBody(table[j].getMIValue(), aList);
            }
        }
    }

    void parseBody(DsfMIValue body, List<DsfMIBreakpoint> aList) {
        if (body instanceof DsfMIList) {
            DsfMIResult[] bkpts = ((DsfMIList)body).getMIResults();
            for (int i = 0; i < bkpts.length; ++i) {
                DsfMIValue value;
                String b = bkpts[i].getVariable();
                if (!b.equals("bkpt") || !((value = bkpts[i].getMIValue()) instanceof DsfMITuple)) continue;
                aList.add(new DsfMIBreakpoint((DsfMITuple)value));
            }
        }
    }
}

