/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

public class DsfMIThreadListIdsInfo
extends DsfMIInfo {
    int[] threadIds;

    public DsfMIThreadListIdsInfo(DsfMIOutput out) {
        super(out);
    }

    public int[] getThreadIds() {
        if (this.threadIds == null) {
            this.parse();
        }
        return this.threadIds;
    }

    void parse() {
        DsfMIOutput out;
        DsfMIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            DsfMIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                DsfMIValue val;
                String var = results[i].getVariable();
                if (!var.equals("thread-ids") || !((val = results[i].getMIValue()) instanceof DsfMITuple)) continue;
                this.parseThreadIds((DsfMITuple)val);
            }
        }
        if (this.threadIds == null) {
            this.threadIds = new int[0];
        }
    }

    void parseThreadIds(DsfMITuple tuple) {
        DsfMIResult[] results = tuple.getMIResults();
        this.threadIds = new int[results.length];
        for (int i = 0; i < results.length; ++i) {
            DsfMIValue value;
            String var = results[i].getVariable();
            if (!var.equals("thread-id") || !((value = results[i].getMIValue()) instanceof DsfMIConst)) continue;
            String str = ((DsfMIConst)value).getCString();
            try {
                this.threadIds[i] = Integer.parseInt(str.trim());
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

