/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.service.MIRunControl;

@Immutable
public class DsfMIBreakpointHitEvent
extends DsfMIStoppedEvent {
    int bkptno;

    protected DsfMIBreakpointHitEvent(IRunControl.IExecutionDMContext ctx, int token, DsfMIResult[] results, DsfMIFrame frame, int bkptno) {
        super(ctx, token, results, frame);
        this.bkptno = bkptno;
    }

    public int getNumber() {
        return this.bkptno;
    }

    public static DsfMIBreakpointHitEvent parse(MIRunControl runControl, IRunControl.IContainerDMContext containerDmc, int token, DsfMIResult[] results) {
        int bkptno = -1;
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof DsfMIConst) {
                str = ((DsfMIConst)value).getString();
            }
            if (!var.equals("bkptno")) continue;
            try {
                bkptno = Integer.parseInt(str.trim());
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        DsfMIStoppedEvent stoppedEvent = DsfMIStoppedEvent.parse(runControl, containerDmc, token, results);
        return new DsfMIBreakpointHitEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), bkptno);
    }
}

