/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMILogStreamOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIStreamRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;

@Immutable
public class DsfMIErrorEvent
extends DsfMIStoppedEvent {
    private final String msg;
    private final String log;
    private final DsfMIOOBRecord[] oobs;

    protected DsfMIErrorEvent(IRunControl.IExecutionDMContext ctx, int token, DsfMIResult[] results, DsfMIOOBRecord[] oobs, String msg, String log) {
        super(ctx, token, results, null);
        this.msg = msg;
        this.log = log;
        this.oobs = oobs;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getLogMessage() {
        return this.log;
    }

    public static DsfMIErrorEvent parse(IRunControl.IContainerDMContext containerDmc, int token, DsfMIResult[] results, DsfMIOOBRecord[] oobs) {
        String msg = "";
        String log = "";
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof DsfMIConst) {
                    str = ((DsfMIConst)value).getString();
                }
                if (!var.equals("msg")) continue;
                msg = str;
            }
        }
        if (oobs != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < oobs.length; ++i) {
                if (!(oobs[i] instanceof DsfMILogStreamOutput)) continue;
                DsfMIStreamRecord o = (DsfMIStreamRecord)oobs[i];
                sb.append(o.getString());
            }
            log = sb.toString();
        }
        return new DsfMIErrorEvent((IRunControl.IExecutionDMContext)containerDmc, token, results, oobs, msg, log);
    }

    public String toString() {
        if (this.oobs != null) {
            StringBuilder builder = new StringBuilder();
            for (DsfMIOOBRecord oob : this.oobs) {
                builder.append(oob.toString());
            }
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }
}

