/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.service.MIRunControl;

@Immutable
public class DsfMISignalEvent
extends DsfMIStoppedEvent {
    private final String sigName;
    private final String sigMeaning;

    protected DsfMISignalEvent(IRunControl.IExecutionDMContext ctx, int token, DsfMIResult[] results, DsfMIFrame frame, String sigName, String sigMeaning) {
        super(ctx, token, results, frame);
        this.sigName = sigName;
        this.sigMeaning = sigMeaning;
    }

    public String getName() {
        return this.sigName;
    }

    public String getMeaning() {
        return this.sigMeaning;
    }

    public static DsfMISignalEvent parse(MIRunControl runControl, IRunControl.IContainerDMContext containerDmc, int token, DsfMIResult[] results) {
        String sigName = "";
        String sigMeaning = "";
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof DsfMIConst) {
                str = ((DsfMIConst)value).getString();
            }
            if (var.equals("signal-name")) {
                sigName = str;
                continue;
            }
            if (!var.equals("signal-meaning")) continue;
            sigMeaning = str;
        }
        DsfMIStoppedEvent stoppedEvent = DsfMIStoppedEvent.parse(runControl, containerDmc, token, results);
        return new DsfMISignalEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), sigName, sigMeaning);
    }
}

