/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIEvent;
import org.eclipse.dd.dsf.mi.service.MIRunControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DsfMIStoppedEvent
extends DsfMIEvent<IRunControl.IExecutionDMContext> {
    private final DsfMIFrame frame;

    protected DsfMIStoppedEvent(IRunControl.IExecutionDMContext ctx, int token, DsfMIResult[] results, DsfMIFrame frame) {
        super(ctx, token, results);
        this.frame = frame;
    }

    public DsfMIFrame getFrame() {
        return this.frame;
    }

    public static DsfMIStoppedEvent parse(MIRunControl runControl, IRunControl.IContainerDMContext containerDmc, int token, DsfMIResult[] results) {
        int threadId = -1;
        DsfMIFrame frame = null;
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            if (var.equals("thread-id")) {
                if (!(value instanceof DsfMIConst)) continue;
                String str = ((DsfMIConst)value).getString();
                try {
                    threadId = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!var.equals("frame") || !(value instanceof DsfMITuple)) continue;
            frame = new DsfMIFrame((DsfMITuple)value);
        }
        Object execDmc = containerDmc;
        if (runControl != null && threadId != -1) {
            execDmc = runControl.createMIExecutionContext(containerDmc, threadId);
        }
        return new DsfMIStoppedEvent((IRunControl.IExecutionDMContext)execDmc, token, results, frame);
    }
}

