/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.service.MIRunControl;

@Immutable
public class DsfMIWatchpointScopeEvent
extends DsfMIStoppedEvent {
    private final int number;

    protected DsfMIWatchpointScopeEvent(IRunControl.IExecutionDMContext ctx, int token, DsfMIResult[] results, DsfMIFrame frame, int number) {
        super(ctx, token, results, frame);
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public static DsfMIWatchpointScopeEvent parse(MIRunControl runControl, IRunControl.IContainerDMContext containerDmc, int token, DsfMIResult[] results) {
        int number = 0;
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            if (!var.equals("wpnum") || !(value instanceof DsfMIConst)) continue;
            String str = ((DsfMIConst)value).getString();
            try {
                number = Integer.parseInt(str.trim());
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        DsfMIStoppedEvent stoppedEvent = DsfMIStoppedEvent.parse(runControl, containerDmc, token, results);
        return new DsfMIWatchpointScopeEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), number);
    }
}

