/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.service.MIRunControl;

@Immutable
public class DsfMIWatchpointTriggerEvent
extends DsfMIStoppedEvent {
    private final int number;
    private final String exp;
    private final String oldValue;
    private final String newValue;

    protected DsfMIWatchpointTriggerEvent(IRunControl.IExecutionDMContext ctx, int token, DsfMIResult[] results, DsfMIFrame frame, int number, String exp, String oldValue, String newValue) {
        super(ctx, token, results, frame);
        this.number = number;
        this.exp = exp;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public int getNumber() {
        return this.number;
    }

    public String getExpression() {
        return this.exp;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public static DsfMIWatchpointTriggerEvent parse(MIRunControl runControl, IRunControl.IContainerDMContext containerDmc, int token, DsfMIResult[] results) {
        int number = 0;
        String exp = "";
        String oldValue = "";
        String newValue = "";
        for (int i = 0; i < results.length; ++i) {
            String str;
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            if (var.equals("wpt") || var.equals("hw-awpt") || var.equals("hw-rwpt")) {
                if (!(value instanceof DsfMITuple)) continue;
                for (DsfMIResult wptResult : ((DsfMITuple)value).getMIResults()) {
                    String wptVar = wptResult.getVariable();
                    DsfMIValue wptValue = wptResult.getMIValue();
                    if (wptVar.equals("number")) {
                        if (!(wptValue instanceof DsfMIConst)) continue;
                        str = ((DsfMIConst)wptValue).getString();
                        try {
                            number = Integer.parseInt(str);
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (!wptVar.equals("exp") || !(wptValue instanceof DsfMIConst)) continue;
                    exp = ((DsfMIConst)wptValue).getString();
                }
                continue;
            }
            if (!var.equals("value") || !(value instanceof DsfMITuple)) continue;
            for (DsfMIResult valueResult : ((DsfMITuple)value).getMIResults()) {
                String valueVar = valueResult.getVariable();
                DsfMIValue valueValue = valueResult.getMIValue();
                str = "";
                if (valueValue instanceof DsfMIConst) {
                    str = ((DsfMIConst)valueValue).getString();
                }
                if (valueVar.equals("old")) {
                    oldValue = str;
                    continue;
                }
                if (valueVar.equals("new")) {
                    newValue = str;
                    continue;
                }
                if (!valueVar.equals("value")) continue;
                oldValue = newValue = str;
            }
        }
        DsfMIStoppedEvent stoppedEvent = DsfMIStoppedEvent.parse(runControl, containerDmc, token, results);
        return new DsfMIWatchpointTriggerEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), number, exp, oldValue, newValue);
    }
}

