/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service.control;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfCLICommand;
import org.eclipse.dd.dsf.mi.core.command.DsfMICommand;
import org.eclipse.dd.dsf.mi.core.command.DsfMIInterpreterExecConsole;
import org.eclipse.dd.dsf.mi.core.command.DsfRawCommand;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConsoleStreamOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMILogStreamOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIStreamRecord;
import org.eclipse.dd.dsf.mi.service.control.AbstractMIControl;
import org.eclipse.dd.dsf.mi.service.control.CLIEventProcessor;
import org.eclipse.dd.dsf.service.DsfSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractCLIProcess
extends Process
implements IEventListener,
ICommandListener {
    public static final String PRIMARY_PROMPT = "(gdb)";
    public static final String SECONDARY_PROMPT = ">";
    private final DsfSession fSession;
    private final AbstractMIControl fCommandControl;
    private final OutputStream fOutputStream;
    private final PipedInputStream fMIInConsolePipe;
    private final PipedOutputStream fMIOutConsolePipe;
    private final PipedInputStream fMIInLogPipe;
    private final PipedOutputStream fMIOutLogPipe;
    private final boolean fUseExecConsole;
    private boolean fDisposed;
    private int fSuppressConsoleOutputCounter;
    private int fPrompt;

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public AbstractCLIProcess(AbstractMIControl commandControl, boolean useExecConsole) throws IOException {
        PipedOutputStream miOutLogPipe;
        PipedInputStream miInLogPipe;
        PipedOutputStream miOutConsolePipe;
        PipedInputStream miInConsolePipe;
        block2: {
            this.fOutputStream = new CLIOutputStream();
            this.fDisposed = false;
            this.fSuppressConsoleOutputCounter = 0;
            this.fPrompt = 1;
            this.fSession = commandControl.getSession();
            this.fCommandControl = commandControl;
            this.fUseExecConsole = useExecConsole;
            commandControl.addEventListener(this);
            commandControl.addCommandListener(this);
            miInConsolePipe = null;
            miOutConsolePipe = null;
            miInLogPipe = null;
            miOutLogPipe = null;
            try {
                miOutConsolePipe = new PipedOutputStream();
                miInConsolePipe = new PipedInputStream(miOutConsolePipe);
                miOutLogPipe = new PipedOutputStream();
                miInLogPipe = new PipedInputStream(miOutLogPipe);
            }
            catch (IOException e) {
                ILog log = DsfMIPlugin.getDefault().getLog();
                if (log == null) break block2;
                log.log((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", -1, "Error when creating log pipes", (Throwable)e));
            }
        }
        this.fMIOutConsolePipe = miOutConsolePipe;
        this.fMIInConsolePipe = miInConsolePipe;
        this.fMIOutLogPipe = miOutLogPipe;
        this.fMIInLogPipe = miInLogPipe;
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected AbstractMIControl getCommandControl() {
        return this.fCommandControl;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public void dispose() {
        this.fCommandControl.removeEventListener(this);
        this.fCommandControl.removeCommandListener(this);
        this.closeIO();
        this.fDisposed = true;
    }

    private void closeIO() {
        try {
            this.fMIOutConsolePipe.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fMIInConsolePipe.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fMIOutLogPipe.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fMIInLogPipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public InputStream getErrorStream() {
        return this.fMIInLogPipe;
    }

    @Override
    public InputStream getInputStream() {
        return this.fMIInConsolePipe;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public void eventReceived(Object output) {
        if (this.fSuppressConsoleOutputCounter > 0) {
            return;
        }
        for (DsfMIOOBRecord oobr : ((DsfMIOutput)output).getMIOOBRecords()) {
            String str;
            DsfMIStreamRecord out;
            if (oobr instanceof DsfMIConsoleStreamOutput) {
                out = (DsfMIConsoleStreamOutput)oobr;
                str = out.getString();
                this.setPrompt(str);
                try {
                    this.fMIOutConsolePipe.write(str.getBytes());
                    this.fMIOutConsolePipe.flush();
                }
                catch (IOException e) {}
                continue;
            }
            if (!(oobr instanceof DsfMILogStreamOutput) || (str = (out = (DsfMILogStreamOutput)oobr).getString()) == null) continue;
            try {
                this.fMIOutLogPipe.write(str.getBytes());
                this.fMIOutLogPipe.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void commandQueued(ICommand<? extends ICommandResult> command) {
    }

    public void commandSent(ICommand<? extends ICommandResult> command) {
        if (command instanceof DsfCLICommand && !(command instanceof ProcessCLICommand) && !(command instanceof ProcessMIInterpreterExecConsole)) {
            ++this.fSuppressConsoleOutputCounter;
        }
    }

    public void commandRemoved(ICommand<? extends ICommandResult> command) {
    }

    public void commandDone(ICommand<? extends ICommandResult> command, ICommandResult result) {
        if (command instanceof DsfCLICommand && !(command instanceof ProcessCLICommand) && !(command instanceof ProcessMIInterpreterExecConsole)) {
            --this.fSuppressConsoleOutputCounter;
        }
    }

    void setPrompt(String line) {
        this.fPrompt = 0;
        if (line == null) {
            return;
        }
        if ((line = line.trim()).equals(PRIMARY_PROMPT)) {
            this.fPrompt = 1;
        } else if (line.equals(SECONDARY_PROMPT)) {
            this.fPrompt = 2;
        }
    }

    public boolean inPrimaryPrompt() {
        return this.fPrompt == 1;
    }

    public boolean inSecondaryPrompt() {
        return this.fPrompt == 2;
    }

    private class CLIOutputStream
    extends OutputStream {
        private final StringBuffer buf = new StringBuffer();

        private CLIOutputStream() {
        }

        public void write(int b) throws IOException {
            this.buf.append((char)b);
            if (b == 10) {
                final String bufString = this.buf.toString().trim();
                this.buf.setLength(0);
                try {
                    AbstractCLIProcess.this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            try {
                                CLIOutputStream.this.post(bufString);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        public void post(String str) throws IOException {
            if (AbstractCLIProcess.this.isDisposed()) {
                return;
            }
            DsfMICommand cmd = null;
            boolean secondary = AbstractCLIProcess.this.inSecondaryPrompt();
            cmd = secondary ? new DsfRawCommand((IDMContext)AbstractCLIProcess.this.getCommandControl().getControlDMContext(), str) : (AbstractCLIProcess.this.fUseExecConsole && !CLIEventProcessor.isSteppingOperation(str) ? new ProcessMIInterpreterExecConsole((IDMContext)AbstractCLIProcess.this.getCommandControl().getControlDMContext(), str) : new ProcessCLICommand((IDMContext)AbstractCLIProcess.this.getCommandControl().getControlDMContext(), str));
            final DsfRawCommand finalCmd = cmd;
            AbstractCLIProcess.this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (AbstractCLIProcess.this.isDisposed()) {
                        return;
                    }
                    AbstractCLIProcess.this.getCommandControl().queueCommand(finalCmd, null);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessCLICommand
    extends DsfCLICommand<DsfMIInfo> {
        public ProcessCLICommand(IDMContext ctx, String oper) {
            super(ctx, oper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessMIInterpreterExecConsole
    extends DsfMIInterpreterExecConsole<DsfMIInfo> {
        public ProcessMIInterpreterExecConsole(IDMContext ctx, String cmd) {
            super(ctx, cmd);
        }
    }
}

