/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service.control;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.mi.core.command.DsfCLIExecAbort;
import org.eclipse.dd.dsf.mi.core.command.DsfMIGDBShowExitCode;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIGDBShowExitCodeInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITargetStreamOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.service.control.AbstractMIControl;
import org.eclipse.dd.dsf.service.DsfSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIInferiorProcess
extends Process
implements IEventListener,
ICommandListener {
    private final OutputStream fOutputStream;
    private final InputStream fInputStream;
    private final PipedOutputStream fInputStreamPiped;
    private final PipedInputStream fErrorStream;
    private final PipedOutputStream fErrorStreamPiped;
    private final DsfSession fSession;
    private final PTY fPty;
    private final AbstractMIControl fCommandControl;
    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private boolean fDisposed = false;
    Integer fExitCode = null;
    private State fState = State.RUNNING;
    int inferiorPID;

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public MIInferiorProcess(AbstractMIControl commandControl, OutputStream gdbOutputStream) {
        this(commandControl, gdbOutputStream, null);
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public MIInferiorProcess(AbstractMIControl commandControl, PTY p) {
        this(commandControl, null, p);
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private MIInferiorProcess(AbstractMIControl commandControl, final OutputStream gdbOutputStream, PTY p) {
        this.fCommandControl = commandControl;
        this.fSession = commandControl.getSession();
        commandControl.addEventListener(this);
        commandControl.addCommandListener(this);
        this.fPty = p;
        if (this.fPty != null) {
            this.fOutputStream = this.fPty.getOutputStream();
            this.fInputStream = this.fPty.getInputStream();
            this.fInputStreamPiped = null;
        } else {
            this.fOutputStream = new OutputStream(){

                public void write(int b) throws IOException {
                    if (MIInferiorProcess.this.getState() != State.RUNNING) {
                        throw new IOException("Target is not running");
                    }
                    gdbOutputStream.write(b);
                }
            };
            this.fInputStreamPiped = new PipedOutputStream();
            PipedInputStream inputStream = null;
            try {
                inputStream = new PipedInputStream(this.fInputStreamPiped);
            }
            catch (IOException e) {
                // empty catch block
            }
            this.fInputStream = inputStream;
        }
        this.fErrorStreamPiped = new PipedOutputStream();
        PipedInputStream errorStream = null;
        try {
            errorStream = new PipedInputStream(this.fErrorStreamPiped);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.fErrorStream = errorStream;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public void dispose() {
        this.fCommandControl.removeEventListener(this);
        this.fCommandControl.removeCommandListener(this);
        this.closeIO();
        this.setState(State.TERMINATED);
        this.fDisposed = true;
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected AbstractMIControl getCommandControl() {
        return this.fCommandControl;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.fInputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.fErrorStream;
    }

    public synchronized void waitForSync() throws InterruptedException {
        while (this.getState() != State.TERMINATED) {
            this.wait(100L);
        }
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.waitForSync();
        return this.exitValue();
    }

    @Override
    public int exitValue() {
        block6: {
            if (this.fExitCode != null) {
                return this.fExitCode;
            }
            try {
                Query<Integer> exitCodeQuery = new Query<Integer>(){

                    protected void execute(final DataRequestMonitor<Integer> rm) {
                        if (!DsfSession.isSessionActive((String)MIInferiorProcess.this.fSession.getId())) {
                            this.cancel(false);
                            return;
                        }
                        if (MIInferiorProcess.this.isDisposed()) {
                            rm.setData((Object)0);
                            rm.done();
                        } else if (MIInferiorProcess.this.getState() != State.TERMINATED) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "GDB is still running.", (Throwable)new IllegalThreadStateException()));
                            rm.done();
                        } else {
                            MIInferiorProcess.this.getCommandControl().queueCommand(new DsfMIGDBShowExitCode(MIInferiorProcess.this.getCommandControl().getControlDMContext()), new DataRequestMonitor<DsfMIGDBShowExitCodeInfo>((Executor)MIInferiorProcess.this.fSession.getExecutor(), rm){

                                protected void handleOK() {
                                    rm.setData((Object)((DsfMIGDBShowExitCodeInfo)this.getData()).getCode());
                                    rm.done();
                                }
                            });
                        }
                    }
                };
                this.fSession.getExecutor().execute((Runnable)exitCodeQuery);
                this.fExitCode = (Integer)exitCodeQuery.get();
                return this.fExitCode;
            }
            catch (RejectedExecutionException e) {
            }
            catch (InterruptedException e) {
            }
            catch (CancellationException e) {
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof CoreException) || !(((CoreException)e.getCause()).getStatus().getException() instanceof RuntimeException)) break block6;
                throw (RuntimeException)((CoreException)e.getCause()).getStatus().getException();
            }
        }
        return 0;
    }

    @Override
    public void destroy() {
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    MIInferiorProcess.this.doDestroy();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.closeIO();
    }

    private void closeIO() {
        try {
            this.fOutputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fInputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fInputStreamPiped.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fErrorStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fErrorStreamPiped.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private void doDestroy() {
        if (this.isDisposed() || !this.fSession.isActive() || this.getState() == State.TERMINATED) {
            return;
        }
        DsfCLIExecAbort cmd = new DsfCLIExecAbort(this.getCommandControl().getControlDMContext());
        this.getCommandControl().queueCommand(cmd, new DataRequestMonitor<DsfMIInfo>(ImmediateExecutor.getInstance(), null){

            protected void handleCompleted() {
                MIInferiorProcess.this.setState(State.TERMINATED);
            }
        });
    }

    public State getState() {
        return this.fState;
    }

    synchronized void setState(State state) {
        if (this.fState == State.TERMINATED) {
            return;
        }
        this.fState = state;
        if (this.fState == State.TERMINATED) {
            this.closeIO();
        }
        this.notifyAll();
    }

    public OutputStream getPipedOutputStream() {
        return this.fInputStreamPiped;
    }

    public OutputStream getPipedErrorStream() {
        return this.fErrorStreamPiped;
    }

    public PTY getPTY() {
        return this.fPty;
    }

    public void eventReceived(Object output) {
        for (DsfMIOOBRecord oobr : ((DsfMIOutput)output).getMIOOBRecords()) {
            if (oobr instanceof DsfMIExecAsyncOutput) {
                DsfMIExecAsyncOutput async = (DsfMIExecAsyncOutput)oobr;
                String state = async.getAsyncClass();
                if (!"stopped".equals(state)) continue;
                boolean handled = false;
                DsfMIResult[] results = async.getMIResults();
                for (int i = 0; i < results.length; ++i) {
                    DsfMIValue value;
                    String var = results[i].getVariable();
                    if (!var.equals("reason") || !((value = results[i].getMIValue()) instanceof DsfMIConst)) continue;
                    String reason = ((DsfMIConst)value).getString();
                    if ("exited-signalled".equals(reason) || "exited-normally".equals(reason) || "exited".equals(reason)) {
                        this.setState(State.TERMINATED);
                    } else {
                        this.setState(State.STOPPED);
                    }
                    handled = true;
                }
                if (handled) continue;
                this.setState(State.STOPPED);
                continue;
            }
            if (!(oobr instanceof DsfMITargetStreamOutput)) continue;
            DsfMITargetStreamOutput tgtOut = (DsfMITargetStreamOutput)oobr;
            if (this.fInputStreamPiped == null || tgtOut.getString() == null) continue;
            try {
                this.fInputStreamPiped.write(tgtOut.getString().getBytes());
                this.fInputStreamPiped.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void commandQueued(ICommand<? extends ICommandResult> command) {
    }

    public void commandSent(ICommand<? extends ICommandResult> command) {
    }

    public void commandRemoved(ICommand<? extends ICommandResult> command) {
    }

    public void commandDone(ICommand<? extends ICommandResult> cmd, ICommandResult result) {
        DsfMIInfo cmdResult = (DsfMIInfo)result;
        DsfMIOutput output = cmdResult.getMIOutput();
        DsfMIResultRecord rr = output.getMIResultRecord();
        String state = rr.getResultClass();
        if ("running".equals(state)) {
            this.setState(State.RUNNING);
        } else if ("exit".equals(state)) {
            this.setState(State.TERMINATED);
        } else if ("error".equals(state)) {
            this.setState(State.STOPPED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        RUNNING,
        STOPPED,
        TERMINATED;

    }
}

