/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVMLayoutNode
implements IVMLayoutNode {
    private final AbstractVMProvider fProvider;
    private boolean fDisposed = false;
    private IVMLayoutNode[] fChildNodes = new IVMLayoutNode[0];

    public AbstractVMLayoutNode(AbstractVMProvider provider) {
        this.fProvider = provider;
    }

    protected DsfExecutor getExecutor() {
        return this.fProvider.getExecutor();
    }

    @Override
    public IVMProvider getVMProvider() {
        return this.fProvider;
    }

    @Override
    public void setChildNodes(IVMLayoutNode[] childNodes) {
        this.fChildNodes = childNodes;
    }

    @Override
    public IVMLayoutNode[] getChildLayoutNodes() {
        return this.fChildNodes;
    }

    @Override
    public void dispose() {
        this.fDisposed = true;
        for (IVMLayoutNode childNode : this.getChildLayoutNodes()) {
            childNode.dispose();
        }
    }

    @Override
    public int getDeltaFlags(Object e) {
        int retVal = 0;
        for (IVMLayoutNode childNode : this.getChildLayoutNodes()) {
            int childNodeDeltaFlags = childNode.getDeltaFlags(e);
            if ((childNodeDeltaFlags | 0x400) != 0) {
                childNodeDeltaFlags &= 0xFFFFFBFF;
                childNodeDeltaFlags |= 0x800;
            }
            retVal |= childNode.getDeltaFlags(e);
        }
        return retVal;
    }

    @Override
    public void buildDelta(final Object event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        final Map<IVMLayoutNode, Integer> childNodesWithDeltaFlags = this.getChildNodesWithDeltaFlags(event);
        if (childNodesWithDeltaFlags.size() == 0) {
            requestMonitor.done();
            return;
        }
        boolean mustGetElements = false;
        for (int childDelta : childNodesWithDeltaFlags.values()) {
            if ((childDelta & 0xFFFFF7FF) == 0) continue;
            mustGetElements = true;
        }
        if (!mustGetElements) {
            this.callChildNodesToBuildDelta(childNodesWithDeltaFlags, parentDelta, event, requestMonitor);
        } else {
            this.updateElements(new ElementsUpdate(new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (AbstractVMLayoutNode.this.fDisposed) {
                        return;
                    }
                    if (!this.getStatus().isOK() || ((List)this.getData()).size() == 0) {
                        requestMonitor.done();
                        return;
                    }
                    MultiRequestMonitor<RequestMonitor> elementsDeltasMultiRequestMon = new MultiRequestMonitor<RequestMonitor>((Executor)AbstractVMLayoutNode.this.getExecutor(), null){

                        protected void handleCompleted() {
                            if (AbstractVMLayoutNode.this.isDisposed()) {
                                return;
                            }
                            requestMonitor.done();
                        }
                    };
                    for (int i = 0; i < ((List)this.getData()).size(); ++i) {
                        VMDelta delta = parentDelta.addNode(((List)this.getData()).get(i), nodeOffset + i, 0);
                        AbstractVMLayoutNode.this.callChildNodesToBuildDelta(childNodesWithDeltaFlags, delta, event, elementsDeltasMultiRequestMon.add(new RequestMonitor((Executor)AbstractVMLayoutNode.this.getExecutor(), null, (MultiRequestMonitor)elementsDeltasMultiRequestMon){
                            final /* synthetic */ MultiRequestMonitor val$elementsDeltasMultiRequestMon;
                            {
                                this.val$elementsDeltasMultiRequestMon = multiRequestMonitor;
                                super(x0, x1);
                            }

                            protected void handleCompleted() {
                                this.val$elementsDeltasMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                            }
                        }));
                    }
                }
            }, (IModelDelta)parentDelta));
        }
    }

    protected void callChildNodesToBuildDelta(final Map<IVMLayoutNode, Integer> nodes, final VMDelta delta, final Object event, final RequestMonitor requestMonitor) {
        assert (nodes.size() != 0);
        boolean calculateOffsets = false;
        for (int childDelta : nodes.values()) {
            if ((childDelta & 0x300000) == 0) continue;
            calculateOffsets = true;
            break;
        }
        this.getChildNodesElementOffsets((IModelDelta)delta, !calculateOffsets, new DataRequestMonitor<Map<IVMLayoutNode, Integer>>((Executor)this.getExecutor(), null){

            protected void handleCompleted() {
                if (AbstractVMLayoutNode.this.isDisposed()) {
                    return;
                }
                MultiRequestMonitor<RequestMonitor> childrenBuildDeltaDoneCollector = new MultiRequestMonitor<RequestMonitor>((Executor)AbstractVMLayoutNode.this.getExecutor(), null){

                    protected void handleCompleted() {
                        if (AbstractVMLayoutNode.this.isDisposed()) {
                            return;
                        }
                        requestMonitor.done();
                    }
                };
                delta.setChildCount((Integer)((Map)this.getData()).get(null));
                for (IVMLayoutNode node : nodes.keySet()) {
                    node.buildDelta(event, delta, (Integer)((Map)this.getData()).get(node), childrenBuildDeltaDoneCollector.add(new RequestMonitor((Executor)AbstractVMLayoutNode.this.getExecutor(), null, (MultiRequestMonitor)childrenBuildDeltaDoneCollector){
                        final /* synthetic */ MultiRequestMonitor val$childrenBuildDeltaDoneCollector;
                        {
                            this.val$childrenBuildDeltaDoneCollector = multiRequestMonitor;
                            super(x0, x1);
                        }

                        protected void handleCompleted() {
                            this.val$childrenBuildDeltaDoneCollector.requestMonitorDone((RequestMonitor)this);
                        }
                    }));
                }
            }
        });
    }

    private void getChildNodesElementOffsets(IModelDelta delta, boolean fakeIt, final DataRequestMonitor<Map<IVMLayoutNode, Integer>> rm) {
        assert (this.getChildLayoutNodes().length != 0);
        if (!fakeIt) {
            final Integer[] counts = new Integer[this.getChildLayoutNodes().length];
            MultiRequestMonitor<RequestMonitor> childrenCountMultiRequestMon = new MultiRequestMonitor<RequestMonitor>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (AbstractVMLayoutNode.this.isDisposed()) {
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    HashMap<IVMLayoutNode, Integer> data = new HashMap<IVMLayoutNode, Integer>();
                    int offset = 0;
                    for (int i = 0; i < AbstractVMLayoutNode.this.getChildLayoutNodes().length; ++i) {
                        data.put(AbstractVMLayoutNode.this.getChildLayoutNodes()[i], offset);
                        offset += counts[i].intValue();
                    }
                    data.put(null, offset);
                    rm.setData(data);
                    rm.done();
                }
            };
            for (int i = 0; i < this.getChildLayoutNodes().length; ++i) {
                final int nodeIndex = i;
                this.getChildLayoutNodes()[i].updateElementCount(new ElementsCountUpdate((DataRequestMonitor<Integer>)((DataRequestMonitor)childrenCountMultiRequestMon.add((RequestMonitor)new DataRequestMonitor<Integer>((Executor)this.getExecutor(), null, (MultiRequestMonitor)childrenCountMultiRequestMon){
                    final /* synthetic */ MultiRequestMonitor val$childrenCountMultiRequestMon;
                    {
                        this.val$childrenCountMultiRequestMon = multiRequestMonitor;
                        super(x0, x1);
                    }

                    protected void handleCompleted() {
                        counts[nodeIndex] = (Integer)this.getData();
                        this.val$childrenCountMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                    }
                })), delta));
            }
        } else {
            HashMap<IVMLayoutNode, Integer> data = new HashMap<IVMLayoutNode, Integer>();
            for (int i = 0; i < this.getChildLayoutNodes().length; ++i) {
                data.put(this.getChildLayoutNodes()[i], -1);
            }
            data.put(null, -1);
            rm.setData(data);
            rm.done();
        }
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    protected Map<IVMLayoutNode, Integer> getChildNodesWithDeltaFlags(Object e) {
        HashMap<IVMLayoutNode, Integer> nodes = new HashMap<IVMLayoutNode, Integer>();
        for (IVMLayoutNode childNode : this.getChildLayoutNodes()) {
            int delta = childNode.getDeltaFlags(e);
            if (delta == 0) continue;
            nodes.put(childNode, delta);
        }
        return nodes;
    }

    protected boolean checkUpdate(IViewerUpdate update) {
        if (update.isCanceled()) {
            update.done();
            return false;
        }
        if (this.fDisposed) {
            this.handleFailedUpdate(update);
            return false;
        }
        return true;
    }

    protected void handleFailedUpdate(IViewerUpdate update) {
        if (update instanceof IHasChildrenUpdate) {
            ((IHasChildrenUpdate)update).setHasChilren(false);
        } else if (update instanceof IChildrenCountUpdate) {
            ((IChildrenCountUpdate)update).setChildCount(0);
        } else if (update instanceof ILabelUpdate) {
            ILabelUpdate labelUpdate = (ILabelUpdate)update;
            String[] columns = labelUpdate.getPresentationContext().getColumns();
            for (int i = 0; i < (columns != null ? columns.length : 1); ++i) {
                labelUpdate.setLabel("...", i);
            }
        }
        update.done();
    }

    protected TreePath getTreePathFromDelta(IModelDelta delta) {
        LinkedList<Object> elementList = new LinkedList<Object>();
        IModelDelta listDelta = delta;
        elementList.add(0, listDelta.getElement());
        while (listDelta.getParentDelta() != null) {
            elementList.add(0, listDelta.getElement());
            listDelta = listDelta.getParentDelta();
        }
        return new TreePath(elementList.toArray());
    }

    public static abstract class AbstractVMContext
    implements IVMContext {
        protected final IVMAdapter fVMAdapter;
        protected final IVMLayoutNode fLayoutNode;

        public AbstractVMContext(IVMAdapter adapter, IVMLayoutNode node) {
            this.fVMAdapter = adapter;
            this.fLayoutNode = node;
        }

        public IVMLayoutNode getLayoutNode() {
            return this.fLayoutNode;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isInstance(this.fVMAdapter)) {
                return this.fVMAdapter;
            }
            if (adapter.isInstance(this.fLayoutNode)) {
                return this.fLayoutNode;
            }
            return null;
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ElementsCountUpdate
    extends ViewerUpdate
    implements IChildrenCountUpdate {
        private final DataRequestMonitor<Integer> fElementCountRequestMonitor;

        public ElementsCountUpdate(DataRequestMonitor<Integer> rm, IModelDelta delta) {
            super((RequestMonitor)rm, delta);
            this.fElementCountRequestMonitor = rm;
        }

        public void setChildCount(int numChildren) {
            this.fElementCountRequestMonitor.setData((Object)numChildren);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ElementsUpdate
    extends ViewerUpdate
    implements IChildrenUpdate {
        private final List<Object> fChildren;
        private DataRequestMonitor<List<Object>> fElementUpdateRequestMonitor;

        public ElementsUpdate(DataRequestMonitor<List<Object>> rm, IModelDelta delta) {
            super((RequestMonitor)rm, delta);
            this.fChildren = new ArrayList<Object>();
            this.fElementUpdateRequestMonitor = rm;
            this.fElementUpdateRequestMonitor.setData(this.fChildren);
        }

        public ElementsUpdate(DataRequestMonitor<List<Object>> rm, TreePath path) {
            super((RequestMonitor)rm, path);
            this.fChildren = new ArrayList<Object>();
            this.fElementUpdateRequestMonitor = rm;
            this.fElementUpdateRequestMonitor.setData(this.fChildren);
        }

        public int getOffset() {
            return -1;
        }

        public int getLength() {
            return -1;
        }

        public void setChild(Object child, int offset) {
            this.fChildren.add(offset, child);
        }

        public String toString() {
            return "VMElementsUpdate for all elements under parent = " + this.getElement();
        }
    }

    protected class ViewerUpdate
    implements IViewerUpdate {
        private final RequestMonitor fRequestMonitor;
        private final TreePath fTreePath;
        private IStatus fStatus;
        private boolean fCancelled = false;

        public ViewerUpdate(RequestMonitor requestMonitor, IModelDelta delta) {
            this.fRequestMonitor = requestMonitor;
            LinkedList<Object> elementList = new LinkedList<Object>();
            IModelDelta listDelta = delta;
            elementList.add(0, listDelta.getElement());
            while (listDelta.getParentDelta() != null) {
                elementList.add(0, listDelta.getElement());
                listDelta = listDelta.getParentDelta();
            }
            this.fTreePath = new TreePath(elementList.toArray());
        }

        public ViewerUpdate(RequestMonitor requestMonitor, TreePath path) {
            this.fRequestMonitor = requestMonitor;
            this.fTreePath = path;
        }

        public Object getElement(TreePath path) {
            if (path.getSegmentCount() > 0) {
                return path.getLastSegment();
            }
            return AbstractVMLayoutNode.this.getVMProvider().getRootElement();
        }

        public Object getElement() {
            return this.getElementPath().getLastSegment();
        }

        public IPresentationContext getPresentationContext() {
            return AbstractVMLayoutNode.this.getVMProvider().getPresentationContext();
        }

        public TreePath getElementPath() {
            return this.fTreePath;
        }

        public IStatus getStatus() {
            return this.fStatus;
        }

        public void setStatus(IStatus status) {
            this.fStatus = status;
        }

        public boolean isCanceled() {
            return this.fCancelled;
        }

        public void cancel() {
            this.fCancelled = true;
        }

        public void done() {
            try {
                this.fRequestMonitor.done();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }
}

