/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMRootLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.VMElementsCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMElementsUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasElementsUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfinedToDsfExecutor(value="getVMAdapter#getExecutor")
public abstract class AbstractVMProvider
implements IVMProvider {
    private final AbstractVMAdapter fVMAdapter;
    private final IPresentationContext fPresentationContext;
    private Object fRootElement;
    private ModelProxy fModelProxy = new ModelProxy();
    private boolean fDisposed = false;
    private AtomicReference<IVMRootLayoutNode> fRootLayoutNodeRef = new AtomicReference();

    public AbstractVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext) {
        this.fVMAdapter = adapter;
        this.fPresentationContext = presentationContext;
    }

    @Override
    public IPresentationContext getPresentationContext() {
        return this.fPresentationContext;
    }

    @Override
    public AbstractVMAdapter getVMAdapter() {
        return this.fVMAdapter;
    }

    @ThreadSafe
    protected void setRootLayoutNode(IVMRootLayoutNode rootLayoutNode) {
        IVMRootLayoutNode oldRootLayoutNode = this.fRootLayoutNodeRef.getAndSet(rootLayoutNode);
        if (oldRootLayoutNode != null) {
            oldRootLayoutNode.dispose();
        }
    }

    @ThreadSafe
    protected synchronized ModelProxy getModelProxy() {
        return this.fModelProxy;
    }

    @Override
    @ThreadSafe
    public synchronized Object getRootElement() {
        return this.fRootElement;
    }

    @Override
    @ThreadSafe
    public IVMRootLayoutNode getRootLayoutNode() {
        return this.fRootLayoutNodeRef.get();
    }

    @Override
    public void dispose() {
        this.fDisposed = true;
        if (this.fRootLayoutNodeRef.get() != null) {
            this.fRootLayoutNodeRef.get().dispose();
        }
    }

    @Override
    public void refresh(final IVMContext element) {
        try {
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    if (AbstractVMProvider.this.isDisposed()) {
                        return;
                    }
                    if (element == null) {
                        VMDelta rootDelta = new VMDelta(AbstractVMProvider.this.getRootElement(), 1024);
                        AbstractVMProvider.this.getModelProxy().fireModelChangedNonDispatch((IModelDelta)rootDelta);
                    } else {
                        VMDelta elementDelta = new VMDelta(element, 1024);
                        AbstractVMProvider.this.getModelProxy().fireModelChangedNonDispatch((IModelDelta)elementDelta);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public DsfExecutor getExecutor() {
        return this.fVMAdapter.getExecutor();
    }

    public void update(IHasChildrenUpdate[] updates) {
        HashMap nodeUpdatesMap = new HashMap();
        for (IHasChildrenUpdate update : updates) {
            IVMLayoutNode layoutNode = this.getLayoutNodeForElement(update.getElement());
            if (layoutNode == null) {
                update.done();
                continue;
            }
            if (!nodeUpdatesMap.containsKey(layoutNode)) {
                nodeUpdatesMap.put(layoutNode, new ArrayList());
            }
            ((List)nodeUpdatesMap.get(layoutNode)).add(update);
        }
        for (IVMLayoutNode node : nodeUpdatesMap.keySet()) {
            this.updateNode(node, ((List)nodeUpdatesMap.get(node)).toArray(new IHasChildrenUpdate[((List)nodeUpdatesMap.get(node)).size()]));
        }
    }

    private void updateNode(IVMLayoutNode node, IHasChildrenUpdate[] updates) {
        if (node.getChildLayoutNodes().length == 0) {
            for (IHasChildrenUpdate update : updates) {
                update.setHasChilren(false);
                update.done();
            }
            return;
        }
        VMHasElementsUpdate[][] elementsUpdates = new VMHasElementsUpdate[node.getChildLayoutNodes().length][updates.length];
        for (int i = 0; i < updates.length; ++i) {
            final IHasChildrenUpdate update = updates[i];
            MultiRequestMonitor<DataRequestMonitor<Boolean>> hasChildrenMultiRequestMon = new MultiRequestMonitor<DataRequestMonitor<Boolean>>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (this.getStatus().isOK()) {
                        boolean isContainer = false;
                        for (DataRequestMonitor hasElementsDone : this.getRequestMonitors()) {
                            isContainer |= hasElementsDone.getStatus().isOK() && (Boolean)hasElementsDone.getData() != false;
                        }
                        update.setHasChilren(isContainer);
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    update.done();
                }
            };
            for (int j = 0; j < node.getChildLayoutNodes().length; ++j) {
                elementsUpdates[j][i] = new VMHasElementsUpdate(update, (DataRequestMonitor<Boolean>)((DataRequestMonitor)hasChildrenMultiRequestMon.add((RequestMonitor)new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), null, (MultiRequestMonitor)hasChildrenMultiRequestMon){
                    final /* synthetic */ MultiRequestMonitor val$hasChildrenMultiRequestMon;
                    {
                        this.val$hasChildrenMultiRequestMon = multiRequestMonitor;
                        super(x0, x1);
                    }

                    protected void handleCompleted() {
                        this.val$hasChildrenMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                    }
                })));
            }
        }
        for (int j = 0; j < node.getChildLayoutNodes().length; ++j) {
            node.getChildLayoutNodes()[j].updateHasElements(elementsUpdates[j]);
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        for (final IChildrenCountUpdate update : updates) {
            if (update.isCanceled()) {
                update.done();
                continue;
            }
            this.getChildrenCountsForNode((IViewerUpdate)update, new DataRequestMonitor<Integer[]>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (this.getStatus().isOK()) {
                        int numChildren = 0;
                        for (Integer count : (Integer[])this.getData()) {
                            numChildren += count.intValue();
                        }
                        update.setChildCount(numChildren);
                    } else {
                        update.setChildCount(0);
                    }
                    update.done();
                }
            });
        }
    }

    public void update(IChildrenUpdate[] updates) {
        for (final IChildrenUpdate update : updates) {
            this.getChildrenCountsForNode((IViewerUpdate)update, new DataRequestMonitor<Integer[]>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        update.done();
                        return;
                    }
                    AbstractVMProvider.this.updateChildrenWithCounts(update, (Integer[])this.getData());
                }
            });
        }
    }

    private void getChildrenCountsForNode(IViewerUpdate update, final DataRequestMonitor<Integer[]> rm) {
        if (this.isDisposed()) {
            return;
        }
        IVMLayoutNode layoutNode = this.getLayoutNodeForElement(update.getElement());
        if (layoutNode == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10002, "Stale update.", null));
            rm.done();
            return;
        }
        IVMLayoutNode[] childNodes = layoutNode.getChildLayoutNodes();
        if (childNodes.length == 0) {
            rm.setData((Object)new Integer[0]);
            rm.done();
            return;
        }
        final Integer[] counts = new Integer[childNodes.length];
        MultiRequestMonitor<RequestMonitor> childrenCountMultiReqMon = new MultiRequestMonitor<RequestMonitor>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (!AbstractVMProvider.this.fDisposed) {
                    super.handleCompleted();
                }
            }

            protected void handleOK() {
                rm.setData((Object)counts);
                rm.done();
            }
        };
        for (int i = 0; i < childNodes.length; ++i) {
            final int nodeIndex = i;
            childNodes[i].updateElementCount(new VMElementsCountUpdate(update, (DataRequestMonitor<Integer>)((DataRequestMonitor)childrenCountMultiReqMon.add((RequestMonitor)new DataRequestMonitor<Integer>((Executor)this.getExecutor(), null, (MultiRequestMonitor)childrenCountMultiReqMon){
                final /* synthetic */ MultiRequestMonitor val$childrenCountMultiReqMon;
                {
                    this.val$childrenCountMultiReqMon = multiRequestMonitor;
                    super(x0, x1);
                }

                protected void handleOK() {
                    counts[nodeIndex] = (Integer)this.getData();
                }

                protected void handleCompleted() {
                    super.handleCompleted();
                    this.val$childrenCountMultiReqMon.requestMonitorDone((RequestMonitor)this);
                }
            }))));
        }
    }

    private void updateChildrenWithCounts(final IChildrenUpdate update, Integer[] nodeElementCounts) {
        IVMLayoutNode layoutNode = this.getLayoutNodeForElement(update.getElement());
        if (layoutNode == null) {
            update.done();
            return;
        }
        MultiRequestMonitor<RequestMonitor> elementsMultiRequestMon = new MultiRequestMonitor<RequestMonitor>((Executor)this.getExecutor(), null){

            protected void handleCompleted() {
                update.done();
            }
        };
        int updateStartIdx = update.getOffset();
        int updateEndIdx = update.getOffset() + update.getLength();
        int idx = 0;
        IVMLayoutNode[] layoutNodes = layoutNode.getChildLayoutNodes();
        for (int i = 0; i < layoutNodes.length; ++i) {
            int nodeEndIdx;
            final int nodeStartIdx = idx;
            idx = nodeEndIdx = idx + nodeElementCounts[i];
            if (updateStartIdx > nodeEndIdx || updateEndIdx <= nodeStartIdx) continue;
            final int elementsStartIdx = Math.max(updateStartIdx - nodeStartIdx, 0);
            int elementsEndIdx = Math.min(updateEndIdx - nodeStartIdx, nodeElementCounts[i]);
            final int elementsLength = elementsEndIdx - elementsStartIdx;
            if (elementsLength <= 0) continue;
            layoutNodes[i].updateElements(new VMElementsUpdate(update, elementsStartIdx, elementsLength, (DataRequestMonitor<List<Object>>)((DataRequestMonitor)elementsMultiRequestMon.add((RequestMonitor)new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null, (MultiRequestMonitor)elementsMultiRequestMon){
                final /* synthetic */ MultiRequestMonitor val$elementsMultiRequestMon;
                {
                    this.val$elementsMultiRequestMon = multiRequestMonitor;
                    super(x0, x1);
                }

                protected void handleCompleted() {
                    if (this.getStatus().isOK()) {
                        for (int i = 0; i < elementsLength; ++i) {
                            update.setChild(((List)this.getData()).get(i), elementsStartIdx + nodeStartIdx + i);
                        }
                    }
                    this.val$elementsMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                }
            }))));
        }
        if (elementsMultiRequestMon.getRequestMonitors().isEmpty()) {
            update.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelProxy createModelProxy(Object element, IPresentationContext context) {
        AbstractVMProvider abstractVMProvider = this;
        synchronized (abstractVMProvider) {
            this.fRootElement = element;
            this.fModelProxy = new ModelProxy();
        }
        return this.fModelProxy;
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return null;
    }

    protected IVMLayoutNode getLayoutNodeForElement(Object element) {
        IVMRootLayoutNode rootLayoutNode = this.getRootLayoutNode();
        if (rootLayoutNode == null) {
            return null;
        }
        if (element.equals(this.getRootElement())) {
            return rootLayoutNode;
        }
        if (element instanceof IVMContext && this.isOurLayoutNode(((IVMContext)element).getLayoutNode(), new IVMLayoutNode[]{rootLayoutNode})) {
            return ((IVMContext)element).getLayoutNode();
        }
        return null;
    }

    private boolean isOurLayoutNode(IVMLayoutNode layoutNode, IVMLayoutNode[] nodesToSearch) {
        for (IVMLayoutNode node : nodesToSearch) {
            if (node == layoutNode) {
                return true;
            }
            if (!this.isOurLayoutNode(layoutNode, node.getChildLayoutNodes())) continue;
            return true;
        }
        return false;
    }

    protected void handleEvent(final Object event) {
        try {
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    if (AbstractVMProvider.this.isDisposed()) {
                        return;
                    }
                    IVMRootLayoutNode rootLayoutNode = AbstractVMProvider.this.getRootLayoutNode();
                    if (rootLayoutNode != null && rootLayoutNode.getDeltaFlags(event) != 0) {
                        rootLayoutNode.createDelta(event, new DataRequestMonitor<IModelDelta>((Executor)AbstractVMProvider.this.getExecutor(), null){

                            public void handleCompleted() {
                                if (this.getStatus().isOK()) {
                                    AbstractVMProvider.this.getModelProxy().fireModelChangedNonDispatch((IModelDelta)this.getData());
                                }
                            }

                            public String toString() {
                                return "Result of a delta for event: '" + event.toString() + "' in VMP: '" + AbstractVMProvider.this + "'" + "\n" + ((IModelDelta)this.getData()).toString();
                            }
                        });
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @ThreadSafe
    protected class ModelProxy
    extends AbstractModelProxy {
        private ISchedulingRule fModelChangeRule = new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return this == rule;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }
        };

        protected ModelProxy() {
        }

        public void fireModelChangedNonDispatch(final IModelDelta delta) {
            Job job = new Job("Processing view model delta."){

                protected IStatus run(IProgressMonitor monitor) {
                    ModelProxy.this.fireModelChanged(delta);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.setRule(this.fModelChangeRule);
            job.schedule();
        }
    }
}

