/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.update;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.ui.viewmodel.VMElementsCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMElementsUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasElementsUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VMCache {
    protected Executor fExecutor = new DefaultDsfExecutor();
    protected HashMap<Object, Integer> fChildrenCounts = new HashMap();
    protected HashMap<Object, HashMap<Integer, Object>> fChildren = new HashMap();
    protected HashMap<Object, Boolean> fHasChildren = new HashMap();
    protected HashMap<IDMContext, IDMData> fData = new HashMap();
    protected HashMap<IDMContext, IDMData> fDataArchive = this.fData;

    public HashMap<?, ?>[] getCacheData() {
        return new HashMap[]{this.fHasChildren, this.fChildrenCounts, this.fChildren, this.fData, this.fDataArchive};
    }

    public VMCache() {
    }

    public VMCache(VMCache oldCache) {
        if (oldCache != null) {
            HashMap<?, ?>[] oldCacheData = oldCache.getCacheData();
            this.fHasChildren = oldCacheData[0];
            this.fChildrenCounts = oldCacheData[1];
            this.fChildren = oldCacheData[2];
            this.fData = oldCacheData[3];
            this.fDataArchive = oldCacheData[4];
        }
    }

    protected void flush(boolean archive) {
        if (archive) {
            this.fDataArchive = this.fData;
        }
        this.fData = new HashMap();
        this.fChildrenCounts.clear();
        this.fChildren.clear();
        this.fHasChildren.clear();
    }

    protected boolean isCacheReadEnabled() {
        return true;
    }

    protected boolean isCacheWriteEnabled() {
        return true;
    }

    public IHasChildrenUpdate[] update(IHasChildrenUpdate[] updates) {
        if (!this.isCacheReadEnabled()) {
            return updates;
        }
        Vector<IHasChildrenUpdate> missVector = new Vector<IHasChildrenUpdate>();
        for (IHasChildrenUpdate update : updates) {
            if (this.fHasChildren.containsKey(update.getElement()) && this.isCacheReadEnabled()) {
                update.setHasChilren(this.fHasChildren.get(update.getElement()).booleanValue());
                update.done();
                continue;
            }
            missVector.addElement(update);
        }
        updates = new IHasChildrenUpdate[missVector.size()];
        for (int i = 0; i < updates.length; ++i) {
            final IHasChildrenUpdate update = (IHasChildrenUpdate)missVector.elementAt(i);
            updates[i] = new VMHasElementsUpdate(update, new DataRequestMonitor<Boolean>(this.fExecutor, null){

                protected void handleCompleted() {
                    if (this.getStatus().isOK()) {
                        if (VMCache.this.isCacheWriteEnabled()) {
                            VMCache.this.fHasChildren.put(update.getElement(), (Boolean)this.getData());
                        }
                        update.setHasChilren(((Boolean)this.getData()).booleanValue());
                    }
                    update.done();
                }
            });
        }
        return updates;
    }

    public IChildrenCountUpdate[] update(IChildrenCountUpdate[] updates) {
        if (!this.isCacheReadEnabled()) {
            return updates;
        }
        Vector<IChildrenCountUpdate> missVector = new Vector<IChildrenCountUpdate>();
        for (IChildrenCountUpdate update : updates) {
            if (this.fChildrenCounts.containsKey(update.getElement()) && this.isCacheReadEnabled()) {
                update.setChildCount(this.fChildrenCounts.get(update.getElement()).intValue());
                update.done();
                continue;
            }
            missVector.addElement(update);
        }
        updates = new IChildrenCountUpdate[missVector.size()];
        for (int i = 0; i < updates.length; ++i) {
            final IChildrenCountUpdate update = (IChildrenCountUpdate)missVector.elementAt(i);
            updates[i] = new VMElementsCountUpdate((IViewerUpdate)update, new DataRequestMonitor<Integer>(this.fExecutor, null){

                protected void handleCompleted() {
                    if (this.getStatus().isOK()) {
                        if (VMCache.this.isCacheWriteEnabled()) {
                            VMCache.this.fChildrenCounts.put(update.getElement(), (Integer)this.getData());
                        }
                        update.setChildCount(((Integer)this.getData()).intValue());
                    }
                    update.done();
                }
            });
        }
        return updates;
    }

    public IChildrenUpdate[] update(IChildrenUpdate[] updates) {
        if (!this.isCacheReadEnabled()) {
            return updates;
        }
        Vector<IChildrenUpdate> updatesEntirelyMissingFromCache = new Vector<IChildrenUpdate>();
        for (final IChildrenUpdate update : updates) {
            if (this.fChildren.containsKey(update.getElement()) && this.isCacheReadEnabled()) {
                Vector<Integer> childrenMissingFromCache = new Vector<Integer>();
                for (int i = update.getOffset(); i < update.getOffset() + update.getLength(); ++i) {
                    childrenMissingFromCache.addElement(i);
                }
                childrenMissingFromCache.removeAll(this.fChildren.get(update.getElement()).keySet());
                if (childrenMissingFromCache.size() > 0) {
                    final HashMap<4, VMElementsUpdate> associationsRequestMonitorToChildUpdate = new HashMap<4, VMElementsUpdate>();
                    MultiRequestMonitor<DataRequestMonitor<List<Object>>> childrenMultiRequestMon = new MultiRequestMonitor<DataRequestMonitor<List<Object>>>(this.fExecutor, null){

                        protected void handleCompleted() {
                            if (this.getStatus().isOK()) {
                                for (DataRequestMonitor monitor : this.getRequestMonitors()) {
                                    int offset = ((IChildrenUpdate)associationsRequestMonitorToChildUpdate.get(monitor)).getOffset();
                                    for (Object child : (List)monitor.getData()) {
                                        update.setChild(child, offset++);
                                    }
                                }
                            } else {
                                update.setStatus(this.getStatus());
                            }
                            update.done();
                        }
                    };
                    while (childrenMissingFromCache.size() > 0) {
                        int offset = (Integer)childrenMissingFromCache.elementAt(0);
                        childrenMissingFromCache.removeElementAt(0);
                        int length = 1;
                        while (childrenMissingFromCache.size() > 0 && (Integer)childrenMissingFromCache.elementAt(0) == offset + length) {
                            ++length;
                            childrenMissingFromCache.removeElementAt(0);
                        }
                        DataRequestMonitor<List<Object>> partialUpdateMonitor = new DataRequestMonitor<List<Object>>(this.fExecutor, null, (MultiRequestMonitor)childrenMultiRequestMon){
                            final /* synthetic */ MultiRequestMonitor val$childrenMultiRequestMon;
                            {
                                this.val$childrenMultiRequestMon = multiRequestMonitor;
                                super(x0, x1);
                            }

                            protected void handleCompleted() {
                                this.val$childrenMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                            }
                        };
                        VMElementsUpdate partialUpdate = new VMElementsUpdate(update, offset, length, (DataRequestMonitor<List<Object>>)((DataRequestMonitor)childrenMultiRequestMon.add((RequestMonitor)partialUpdateMonitor)));
                        associationsRequestMonitorToChildUpdate.put(partialUpdateMonitor, partialUpdate);
                        updatesEntirelyMissingFromCache.add(partialUpdate);
                    }
                    continue;
                }
                for (int position = update.getOffset(); position < update.getOffset() + update.getLength(); ++position) {
                    update.setChild(this.fChildren.get(update.getElement()).get(position), position);
                }
                update.done();
                continue;
            }
            updatesEntirelyMissingFromCache.addElement(update);
        }
        updates = new IChildrenUpdate[updatesEntirelyMissingFromCache.size()];
        for (int i = 0; i < updates.length; ++i) {
            final IChildrenUpdate update = (IChildrenUpdate)updatesEntirelyMissingFromCache.elementAt(i);
            updates[i] = new VMElementsUpdate(update, update.getOffset(), update.getLength(), (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.fExecutor, null){

                protected void handleCompleted() {
                    if (this.getData() != null) {
                        for (int j = 0; j < ((List)this.getData()).size(); ++j) {
                            if (VMCache.this.isCacheWriteEnabled()) {
                                if (!VMCache.this.fChildren.containsKey(update.getElement())) {
                                    VMCache.this.fChildren.put(update.getElement(), new HashMap());
                                }
                                VMCache.this.fChildren.get(update.getElement()).put(update.getOffset() + j, ((List)this.getData()).get(j));
                            }
                            update.setChild(((List)this.getData()).get(j), update.getOffset() + j);
                        }
                    }
                    update.done();
                }
            }){

                public void done() {
                    DataRequestMonitor rm = (DataRequestMonitor)this.fRequestMonitor;
                    rm.setData((Object)this.fElements);
                    super.done();
                }
            };
        }
        return updates;
    }

    @ConfinedToDsfExecutor(value="DsfSession.getSession(dmc.getSessionId()).getExecutor()")
    public void getModelData(IDMService service, final IDMContext dmc, final DataRequestMonitor rm, DsfExecutor executor) {
        if (this.fData.containsKey(dmc) && this.isCacheReadEnabled()) {
            rm.setData((Object)this.fData.get(dmc));
            rm.done();
        } else {
            service.getModelData(dmc, (DataRequestMonitor)new DataRequestMonitor<IDMData>((Executor)executor, (RequestMonitor)rm){

                protected void handleOK() {
                    if (VMCache.this.isCacheWriteEnabled()) {
                        VMCache.this.fData.put(dmc, (IDMData)this.getData());
                    }
                    rm.setData(this.getData());
                    rm.done();
                }
            });
        }
    }

    public IDMData getArchivedModelData(IDMContext dmc) {
        return this.fDataArchive.get(dmc);
    }

    public abstract void handleEvent(IDMEvent var1);
}

