/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.update;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCache;

public class VMCacheManager {
    private static VMCacheManager fInstance = null;
    private HashMap<Object, VMCache> fAssociations = new HashMap();
    private HashMap<Object, Vector<CacheListener>> fListeners = new HashMap();

    public static VMCacheManager getVMCacheManager() {
        if (fInstance == null) {
            fInstance = new VMCacheManager();
        }
        return fInstance;
    }

    public VMCache getCache(Object context) {
        if (!this.fAssociations.containsKey(context)) {
            this.fAssociations.put(context, new VMCache(){

                public void handleEvent(IDMEvent event) {
                }

                public boolean isCacheReadEnabled() {
                    return false;
                }

                public boolean isCacheWriteEnabled() {
                    return false;
                }
            });
        }
        return this.fAssociations.get(context);
    }

    public void registerCache(Object context, VMCache cache) {
        this.fAssociations.put(context, cache);
    }

    public void addCacheListener(Object context, CacheListener listener) {
        if (!this.fListeners.containsKey(context)) {
            this.fListeners.put(context, new Vector());
        }
        this.fListeners.get(context).addElement(listener);
    }

    public void removeCacheListener(Object context, CacheListener listener) {
        if (!this.fListeners.containsKey(context)) {
            this.fListeners.get(context).removeElement(listener);
            if (this.fListeners.get(context).isEmpty()) {
                this.fListeners.remove(context);
            }
        }
    }

    private void fireCacheFlushed(Object context) {
        if (this.fListeners.containsKey(context)) {
            for (CacheListener listener : this.fListeners.get(context)) {
                listener.cacheFlushed(context);
            }
        }
    }

    public void flush(Object context) {
        this.getCache(context).flush(false);
        this.fireCacheFlushed(context);
    }

    public static interface CacheListener {
        public void cacheFlushed(Object var1);
    }
}

