/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.properties;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.ui.viewmodel.properties.ILabelAttributeChangedListener;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelColor;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelFont;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class LabelColumnInfo
implements ILabelAttributeChangedListener {
    private static final LabelAttribute[] EMPTY_ATTRIBUTES_ARRAY = new LabelAttribute[0];
    private String[] fPropertyNames;
    private LabelAttribute[] fLabelAttributes;
    private ListenerList fListeners = new ListenerList();

    public LabelColumnInfo(LabelAttribute[] attributes) {
        this.fLabelAttributes = attributes;
        LinkedList<String> names = new LinkedList<String>();
        for (LabelAttribute attr : attributes) {
            attr.addChangedListener(this);
            for (String name : attr.getPropertyNames()) {
                names.add(name);
            }
        }
        this.fPropertyNames = names.toArray(new String[names.size()]);
    }

    public void dispose() {
        for (LabelAttribute attr : this.fLabelAttributes) {
            attr.dispose();
            attr.removeChangedListener(this);
        }
        this.fLabelAttributes = EMPTY_ATTRIBUTES_ARRAY;
        this.fPropertyNames = null;
    }

    public String[] getPropertyNames() {
        return this.fPropertyNames;
    }

    public LabelAttribute[] getLabelAttributes() {
        return this.fLabelAttributes;
    }

    public void addChangedListener(ILabelAttributeChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeChangedListener(ILabelAttributeChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void attributesChanged() {
        Object[] listeners;
        for (Object listener : listeners = this.fListeners.getListeners()) {
            ((ILabelAttributeChangedListener)listener).attributesChanged();
        }
    }

    public void updateColumn(ILabelUpdate update, int columnIndex, Map<String, Object> properties) {
        LabelAttribute[] labelAttributes;
        boolean textSet = false;
        boolean imageSet = false;
        boolean fontSet = false;
        boolean colorSet = false;
        for (LabelAttribute info : labelAttributes = this.getLabelAttributes()) {
            if (info instanceof LabelText && textSet || info instanceof LabelImage && imageSet || info instanceof LabelFont && fontSet || info instanceof LabelColor && colorSet || !info.isEnabled(properties)) continue;
            info.updateAttribute(update, columnIndex, properties);
            textSet = textSet || info instanceof LabelText;
            imageSet = imageSet || info instanceof LabelImage;
            fontSet = fontSet || info instanceof LabelFont;
            colorSet = colorSet || info instanceof LabelColor;
        }
    }
}

