/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfinedToDsfExecutor(value="#getExecutor()")
public class DefaultVMContentProviderStrategy
implements IElementContentProvider {
    private final AbstractVMProvider fVMProvider;

    public DefaultVMContentProviderStrategy(AbstractVMProvider provider) {
        this.fVMProvider = provider;
    }

    protected AbstractVMProvider getVMProvider() {
        return this.fVMProvider;
    }

    public void update(IHasChildrenUpdate[] updates) {
        if (updates.length == 0) {
            return;
        }
        boolean allNodesTheSame = true;
        IVMNode firstNode = this.getNodeForElement(updates[0].getElement());
        for (int i = 1; i < updates.length; ++i) {
            if (firstNode == this.getNodeForElement(updates[i].getElement())) continue;
            allNodesTheSame = false;
            break;
        }
        if (allNodesTheSame) {
            this.updateNode(firstNode, updates);
        } else {
            HashMap nodeUpdatesMap = new HashMap();
            for (IHasChildrenUpdate update : updates) {
                IVMNode node = this.getNodeForElement(update.getElement());
                if (node == null) {
                    update.done();
                    continue;
                }
                if (!nodeUpdatesMap.containsKey(node)) {
                    nodeUpdatesMap.put(node, new ArrayList());
                }
                ((List)nodeUpdatesMap.get(node)).add(update);
            }
            for (IVMNode node : nodeUpdatesMap.keySet()) {
                this.updateNode(node, ((List)nodeUpdatesMap.get(node)).toArray(new IHasChildrenUpdate[((List)nodeUpdatesMap.get(node)).size()]));
            }
        }
    }

    private void updateNode(IVMNode node, IHasChildrenUpdate[] updates) {
        IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(node);
        if (childNodes.length == 0) {
            for (IHasChildrenUpdate update : updates) {
                update.setHasChilren(false);
                update.done();
            }
            return;
        }
        VMHasChildrenUpdate[][] elementsUpdates = new VMHasChildrenUpdate[childNodes.length][updates.length];
        for (int i = 0; i < updates.length; ++i) {
            final IHasChildrenUpdate update = updates[i];
            MultiRequestMonitor<DataRequestMonitor<Boolean>> hasChildrenMultiRequestMon = new MultiRequestMonitor<DataRequestMonitor<Boolean>>((Executor)this.getVMProvider().getExecutor(), null){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        boolean isContainer = false;
                        for (DataRequestMonitor hasElementsDone : this.getRequestMonitors()) {
                            isContainer |= hasElementsDone.isSuccess() && (Boolean)hasElementsDone.getData() != false;
                        }
                        update.setHasChilren(isContainer);
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    update.done();
                }
            };
            for (int j = 0; j < childNodes.length; ++j) {
                elementsUpdates[j][i] = new VMHasChildrenUpdate((IViewerUpdate)update, (DataRequestMonitor<Boolean>)((DataRequestMonitor)hasChildrenMultiRequestMon.add((RequestMonitor)new DataRequestMonitor<Boolean>((Executor)this.getVMProvider().getExecutor(), null, (MultiRequestMonitor)hasChildrenMultiRequestMon){
                    final /* synthetic */ MultiRequestMonitor val$hasChildrenMultiRequestMon;
                    {
                        this.val$hasChildrenMultiRequestMon = multiRequestMonitor;
                        super(x0, x1);
                    }

                    protected void handleCompleted() {
                        this.val$hasChildrenMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                    }
                })));
            }
        }
        for (int j = 0; j < childNodes.length; ++j) {
            this.getVMProvider().updateNode(childNodes[j], elementsUpdates[j]);
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        for (final IChildrenCountUpdate update : updates) {
            IVMNode node = this.getNodeForElement(update.getElement());
            if (node != null && !update.isCanceled()) {
                IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(node);
                if (childNodes.length == 0) {
                    update.setChildCount(0);
                    update.done();
                    continue;
                }
                if (childNodes.length == 1) {
                    this.getVMProvider().updateNode(childNodes[0], update);
                    continue;
                }
                this.getChildrenCountsForNode((IViewerUpdate)update, node, new DataRequestMonitor<Integer[]>((Executor)this.getVMProvider().getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            int numChildren = 0;
                            for (Integer count : (Integer[])this.getData()) {
                                numChildren += count.intValue();
                            }
                            update.setChildCount(numChildren);
                        } else {
                            update.setChildCount(0);
                        }
                        update.done();
                    }
                });
                continue;
            }
            if (!update.isCanceled()) continue;
            update.done();
        }
    }

    public void update(IChildrenUpdate[] updates) {
        for (final IChildrenUpdate update : updates) {
            final IVMNode node = this.getNodeForElement(update.getElement());
            if (node != null && !update.isCanceled()) {
                IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(node);
                if (childNodes.length == 0) {
                    update.done();
                    continue;
                }
                if (childNodes.length == 1) {
                    this.getVMProvider().updateNode(childNodes[0], update);
                    continue;
                }
                this.getChildrenCountsForNode((IViewerUpdate)update, node, new DataRequestMonitor<Integer[]>((Executor)this.getVMProvider().getExecutor(), null){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            update.done();
                            return;
                        }
                        DefaultVMContentProviderStrategy.this.updateChildrenWithCounts(update, node, (Integer[])this.getData());
                    }
                });
                continue;
            }
            update.done();
        }
    }

    private void getChildrenCountsForNode(IViewerUpdate update, IVMNode updateNode, final DataRequestMonitor<Integer[]> rm) {
        IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(updateNode);
        assert (childNodes.length != 0);
        final Integer[] counts = new Integer[childNodes.length];
        MultiRequestMonitor<RequestMonitor> childrenCountMultiReqMon = new MultiRequestMonitor<RequestMonitor>((Executor)this.getVMProvider().getExecutor(), rm){

            protected void handleSuccess() {
                rm.setData((Object)counts);
                rm.done();
            }
        };
        for (int i = 0; i < childNodes.length; ++i) {
            final int nodeIndex = i;
            this.getVMProvider().updateNode(childNodes[i], new VMChildrenCountUpdate(update, (DataRequestMonitor<Integer>)((DataRequestMonitor)childrenCountMultiReqMon.add((RequestMonitor)new DataRequestMonitor<Integer>((Executor)this.getVMProvider().getExecutor(), null, (MultiRequestMonitor)childrenCountMultiReqMon){
                final /* synthetic */ MultiRequestMonitor val$childrenCountMultiReqMon;
                {
                    this.val$childrenCountMultiReqMon = multiRequestMonitor;
                    super(x0, x1);
                }

                protected void handleSuccess() {
                    counts[nodeIndex] = (Integer)this.getData();
                }

                protected void handleCompleted() {
                    super.handleCompleted();
                    this.val$childrenCountMultiReqMon.requestMonitorDone((RequestMonitor)this);
                }
            }))));
        }
    }

    private void updateChildrenWithCounts(final IChildrenUpdate update, IVMNode node, Integer[] nodeElementCounts) {
        MultiRequestMonitor<RequestMonitor> elementsMultiRequestMon = new MultiRequestMonitor<RequestMonitor>((Executor)this.getVMProvider().getExecutor(), null){

            protected void handleCompleted() {
                update.done();
            }
        };
        int updateStartIdx = update.getOffset();
        int updateEndIdx = update.getOffset() + update.getLength();
        int idx = 0;
        IVMNode[] nodes = this.getVMProvider().getChildVMNodes(node);
        for (int i = 0; i < nodes.length; ++i) {
            int nodeEndIdx;
            final int nodeStartIdx = idx;
            idx = nodeEndIdx = idx + nodeElementCounts[i];
            if (updateStartIdx > nodeEndIdx || updateEndIdx <= nodeStartIdx) continue;
            final int elementsStartIdx = Math.max(updateStartIdx - nodeStartIdx, 0);
            int elementsEndIdx = Math.min(updateEndIdx - nodeStartIdx, nodeElementCounts[i]);
            final int elementsLength = elementsEndIdx - elementsStartIdx;
            if (elementsLength <= 0) continue;
            this.getVMProvider().updateNode(nodes[i], new VMChildrenUpdate((IViewerUpdate)update, elementsStartIdx, elementsLength, (DataRequestMonitor<List<Object>>)((DataRequestMonitor)elementsMultiRequestMon.add((RequestMonitor)new DataRequestMonitor<List<Object>>((Executor)this.getVMProvider().getExecutor(), null, (MultiRequestMonitor)elementsMultiRequestMon){
                final /* synthetic */ MultiRequestMonitor val$elementsMultiRequestMon;
                {
                    this.val$elementsMultiRequestMon = multiRequestMonitor;
                    super(x0, x1);
                }

                protected void handleCompleted() {
                    if (this.getData() != null) {
                        for (int i = 0; i < elementsLength && i < ((List)this.getData()).size(); ++i) {
                            Object child = ((List)this.getData()).get(i);
                            if (child == null) continue;
                            update.setChild(((List)this.getData()).get(i), elementsStartIdx + nodeStartIdx + i);
                        }
                    }
                    this.val$elementsMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                }
            }))));
        }
        assert (!elementsMultiRequestMon.getRequestMonitors().isEmpty());
    }

    protected IVMNode getNodeForElement(Object element) {
        if (element instanceof IVMContext) {
            IVMNode node = ((IVMContext)element).getVMNode();
            if (this.isOurNode(((IVMContext)element).getVMNode())) {
                return node;
            }
        }
        return this.getVMProvider().getRootVMNode();
    }

    private boolean isOurNode(IVMNode node) {
        for (IVMNode nodeToSearch : this.getVMProvider().getAllVMNodes()) {
            if (!nodeToSearch.equals(node)) continue;
            return true;
        }
        return false;
    }
}

