/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.LinkedList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

public class VMViewerUpdate
implements IViewerUpdate {
    private final RequestMonitor fRequestMonitor;
    private final IViewerUpdate fClientUpdate;
    private final AtomicBoolean fCanceled;
    private final Object fViewerInput;
    private final Object fElement;
    private final TreePath fElementPath;
    private final IPresentationContext fPresentationContext;

    public VMViewerUpdate(IViewerUpdate clientUpdate, RequestMonitor requestMonitor) {
        this.fViewerInput = clientUpdate.getViewerInput();
        this.fElement = clientUpdate.getElement();
        this.fElementPath = clientUpdate.getElementPath();
        this.fPresentationContext = clientUpdate.getPresentationContext();
        this.fRequestMonitor = requestMonitor;
        this.fClientUpdate = clientUpdate;
        this.fCanceled = null;
    }

    public VMViewerUpdate(IModelDelta delta, IPresentationContext presentationContext, RequestMonitor requestMonitor) {
        LinkedList<Object> elementList = new LinkedList<Object>();
        IModelDelta listDelta = delta;
        elementList.add(0, listDelta.getElement());
        while (listDelta.getParentDelta() != null) {
            listDelta = listDelta.getParentDelta();
            elementList.add(0, listDelta.getElement());
        }
        this.fViewerInput = elementList.get(0);
        this.fElement = elementList.get(elementList.size() - 1);
        elementList.remove(0);
        this.fElementPath = new TreePath(elementList.toArray());
        this.fPresentationContext = presentationContext;
        this.fRequestMonitor = requestMonitor;
        this.fClientUpdate = null;
        this.fCanceled = new AtomicBoolean(false);
    }

    public VMViewerUpdate(TreePath elementPath, Object viewerInput, IPresentationContext presentationContext, RequestMonitor requestMonitor) {
        this.fViewerInput = viewerInput;
        this.fElement = elementPath.getSegmentCount() != 0 ? elementPath.getLastSegment() : viewerInput;
        this.fElementPath = elementPath;
        this.fPresentationContext = presentationContext;
        this.fRequestMonitor = requestMonitor;
        this.fClientUpdate = null;
        this.fCanceled = new AtomicBoolean(false);
    }

    protected RequestMonitor getRequestMonitor() {
        return this.fRequestMonitor;
    }

    public Object getViewerInput() {
        return this.fViewerInput;
    }

    public Object getElement() {
        return this.fElement;
    }

    public TreePath getElementPath() {
        return this.fElementPath;
    }

    public IPresentationContext getPresentationContext() {
        return this.fPresentationContext;
    }

    public IStatus getStatus() {
        return this.fRequestMonitor.getStatus();
    }

    public void setStatus(IStatus status) {
        this.fRequestMonitor.setStatus(status);
    }

    public boolean isCanceled() {
        if (this.fClientUpdate != null) {
            return this.fClientUpdate.isCanceled();
        }
        return this.fCanceled.get();
    }

    public void cancel() {
        if (this.fClientUpdate != null) {
            this.fClientUpdate.cancel();
        } else {
            this.fCanceled.set(true);
        }
    }

    public void done() {
        block3: {
            try {
                if (this.isCanceled()) {
                    this.fRequestMonitor.setStatus((IStatus)new Status(8, "org.eclipse.dd.dsf.ui", " Update was cancelled"));
                }
                this.fRequestMonitor.done();
            }
            catch (RejectedExecutionException e) {
                if (this.fClientUpdate == null) break block3;
                this.fClientUpdate.done();
            }
        }
    }
}

