/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.IElementUpdateTester;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.ManualUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCachingVMProvider
extends AbstractVMProvider
implements ICachingVMProvider {
    private static final int MAX_CACHE_SIZE = 1000;
    protected static String SELECTED_UPDATE_MODE = "org.eclipse.dd.dsf.ui.viewmodel.update.selectedUpdateMode";
    private IVMUpdatePolicy fCurrentUpdatePolicy;
    private IVMUpdatePolicy[] fAvailableUpdatePolicies;
    public Map<Object, RootElementMarkerKey> fRootMarkers = new HashMap<Object, RootElementMarkerKey>();
    private final Map<Object, Entry> fCacheData = new HashMap<Object, Entry>(200, 0.75f);
    private final Entry fCacheListHead;

    public AbstractCachingVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext) {
        super(adapter, presentationContext);
        this.fCacheListHead.fNext = this.fCacheListHead = new Entry(null);
        this.fCacheListHead.fPrevious = this.fCacheListHead;
        String updateModeId = (String)presentationContext.getProperty(SELECTED_UPDATE_MODE);
        if (updateModeId != null) {
            for (IVMUpdatePolicy updateMode : this.getAvailableUpdatePolicies()) {
                if (!updateMode.getID().equals(updateModeId)) continue;
                this.fCurrentUpdatePolicy = updateMode;
            }
        }
        this.fAvailableUpdatePolicies = this.createUpdateModes();
        this.fCurrentUpdatePolicy = this.fAvailableUpdatePolicies[0];
    }

    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new AutomaticUpdatePolicy()};
    }

    @Override
    public IVMUpdatePolicy[] getAvailableUpdatePolicies() {
        return this.fAvailableUpdatePolicies;
    }

    @Override
    public IVMUpdatePolicy getActiveUpdatePolicy() {
        return this.fCurrentUpdatePolicy;
    }

    @Override
    public void setActiveUpdatePolicy(IVMUpdatePolicy updatePolicy) {
        this.fCurrentUpdatePolicy = updatePolicy;
    }

    @Override
    public void refresh() {
        IElementUpdateTester elementTester = this.getActiveUpdatePolicy().getTesterTester(ManualUpdatePolicy.REFRESH_EVENT);
        LinkedList<FlushMarkerKey> flushKeys = new LinkedList<FlushMarkerKey>();
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            flushKeys.add(new FlushMarkerKey(proxyStrategy.getRootElement(), elementTester));
        }
        this.flush(flushKeys);
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            if (proxyStrategy.isDisposed()) continue;
            proxyStrategy.fireModelChanged((IModelDelta)new ModelDelta(proxyStrategy.getRootElement(), 1024));
        }
    }

    @Override
    public void updateNode(IVMNode node, IHasChildrenUpdate[] updates) {
        LinkedList<VMHasChildrenUpdate> missUpdates = new LinkedList<VMHasChildrenUpdate>();
        for (final IHasChildrenUpdate update : updates) {
            ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
            final ElementDataEntry entry = this.getElementDataEntry(key);
            if (entry.fHasChildren != null) {
                update.setHasChilren(entry.fHasChildren.booleanValue());
                update.done();
                continue;
            }
            missUpdates.add(new VMHasChildrenUpdate((IViewerUpdate)update, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        entry.fHasChildren = (Boolean)this.getData();
                        update.setHasChilren(((Boolean)this.getData()).booleanValue());
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    update.done();
                }
            }));
        }
        if (!missUpdates.isEmpty()) {
            super.updateNode(node, missUpdates.toArray(new IHasChildrenUpdate[missUpdates.size()]));
        }
    }

    @Override
    public void updateNode(IVMNode node, final IChildrenCountUpdate update) {
        ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
        final ElementDataEntry entry = this.getElementDataEntry(key);
        if (entry.fChildrenCount != null) {
            update.setChildCount(entry.fChildrenCount.intValue());
            update.done();
        } else {
            VMChildrenCountUpdate updateProxy = new VMChildrenCountUpdate((IViewerUpdate)update, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        entry.fChildrenCount = (Integer)this.getData();
                        update.setChildCount(((Integer)this.getData()).intValue());
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    update.done();
                }
            });
            super.updateNode(node, updateProxy);
        }
    }

    @Override
    public void updateNode(IVMNode node, final IChildrenUpdate update) {
        ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
        final ElementDataEntry entry = this.getElementDataEntry(key);
        if (entry.fChildren == null || update.getOffset() < 0 && !entry.fAllChildrenKnown) {
            VMChildrenUpdate updateProxy = new VMChildrenUpdate((IViewerUpdate)update, update.getOffset(), update.getLength(), new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (this.getData() != null) {
                        Integer childrenCount;
                        int updateOffset = update.getOffset();
                        if (updateOffset < 0) {
                            updateOffset = 0;
                            entry.fAllChildrenKnown = true;
                        }
                        childrenCount = (childrenCount = entry.fChildrenCount) != null ? childrenCount : 0;
                        int capacity = Math.max(childrenCount * 4 / 3, 32);
                        if (entry.fChildren == null) {
                            entry.fChildren = new HashMap<Integer, Object>(capacity);
                        }
                        for (int j = 0; j < ((List)this.getData()).size(); ++j) {
                            int offset = updateOffset + j;
                            Object child = ((List)this.getData()).get(j);
                            if (child == null) continue;
                            entry.fChildren.put(offset, child);
                            update.setChild(child, offset);
                        }
                    }
                    update.done();
                }
            });
            super.updateNode(node, updateProxy);
        } else if (update.getOffset() < 0) {
            assert (entry.fAllChildrenKnown);
            for (int position = 0; position < entry.fChildren.size(); ++position) {
                update.setChild(entry.fChildren.get(position), position);
            }
            update.done();
        } else {
            LinkedList<Integer> childrenMissingFromCache = new LinkedList<Integer>();
            for (int i = update.getOffset(); i < update.getOffset() + update.getLength(); ++i) {
                childrenMissingFromCache.add(i);
            }
            Integer position = update.getOffset();
            while (position < update.getOffset() + update.getLength()) {
                Object child = entry.fChildren.get(position);
                if (child != null) {
                    update.setChild(entry.fChildren.get(position), position.intValue());
                    childrenMissingFromCache.remove(position);
                }
                child = position;
                Integer n = position = Integer.valueOf(position + 1);
            }
            if (childrenMissingFromCache.size() > 0) {
                ArrayList<VMChildrenUpdate> partialUpdates = new ArrayList<VMChildrenUpdate>(2);
                final ViewerCountingRequestMonitor multiRm = new ViewerCountingRequestMonitor((Executor)this.getExecutor(), (IViewerUpdate)update);
                while (childrenMissingFromCache.size() > 0) {
                    final int offset = (Integer)childrenMissingFromCache.get(0);
                    childrenMissingFromCache.remove(0);
                    int n = 1;
                    while (childrenMissingFromCache.size() > 0 && (Integer)childrenMissingFromCache.get(0) == offset + n) {
                        ++n;
                        childrenMissingFromCache.remove(0);
                    }
                    partialUpdates.add(new VMChildrenUpdate((IViewerUpdate)update, offset, n, new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), (RequestMonitor)multiRm){

                        protected void handleCompleted() {
                            if (this.getData() != null) {
                                for (int i = 0; i < ((List)this.getData()).size(); ++i) {
                                    update.setChild(((List)this.getData()).get(i), offset + i);
                                }
                            }
                            multiRm.done();
                        }
                    }));
                }
                for (IChildrenUpdate iChildrenUpdate : partialUpdates) {
                    super.updateNode(node, iChildrenUpdate);
                }
                multiRm.setDoneCount(partialUpdates.size());
            } else {
                update.done();
            }
        }
    }

    private void flush(List<FlushMarkerKey> flushKeys) {
        ArrayList<FlushMarkerKey> flushKeysCopy = new ArrayList<FlushMarkerKey>(flushKeys.size());
        flushKeysCopy.addAll(flushKeys);
        Entry entry = this.fCacheListHead.fPrevious;
        while (entry != this.fCacheListHead && flushKeysCopy.size() != 0) {
            Iterator flushKeyItr = flushKeysCopy.iterator();
            while (flushKeyItr.hasNext()) {
                FlushMarkerKey flushKey = (FlushMarkerKey)flushKeyItr.next();
                if (entry.fKey instanceof FlushMarkerKey) {
                    FlushMarkerKey entryFlushKey = (FlushMarkerKey)entry.fKey;
                    if (flushKey.includes(entryFlushKey)) {
                        this.fCacheData.remove(entryFlushKey);
                        entry.remove();
                    }
                    if (!entryFlushKey.includes(flushKey)) continue;
                    flushKeyItr.remove();
                    continue;
                }
                if (!(entry instanceof ElementDataEntry)) continue;
                ElementDataEntry elementDataEntry = (ElementDataEntry)entry;
                int updateFlags = flushKey.getUpdateFlags((ElementDataKey)elementDataEntry.fKey);
                if ((updateFlags & 1) != 0) {
                    if ((updateFlags & 3) != 0) {
                        for (Map.Entry<IDMContext, Object> dataOrStatusEntry : elementDataEntry.fDataOrStatus.entrySet()) {
                            if (!(dataOrStatusEntry.getValue() instanceof IDMData)) continue;
                            elementDataEntry.fArchiveData.put(dataOrStatusEntry.getKey(), (IDMData)dataOrStatusEntry.getValue());
                        }
                        elementDataEntry.fDataOrStatus.clear();
                        if (elementDataEntry.fArchiveData.isEmpty()) {
                            this.fCacheData.remove(entry.fKey);
                            entry.remove();
                        }
                    } else if (!elementDataEntry.fArchiveData.isEmpty()) {
                        elementDataEntry.fDataOrStatus.clear();
                    } else {
                        this.fCacheData.remove(entry.fKey);
                        entry.remove();
                    }
                    elementDataEntry.fHasChildren = null;
                    elementDataEntry.fChildrenCount = null;
                    elementDataEntry.fChildren = null;
                    continue;
                }
                if ((updateFlags & 4) == 0) continue;
                elementDataEntry.fDirty = true;
            }
            entry = entry.fPrevious;
        }
        for (FlushMarkerKey flushKey : flushKeys) {
            Entry flushMarkerEntry = new Entry(flushKey);
            this.fCacheData.put(flushKey, flushMarkerEntry);
            flushMarkerEntry.insert(this.fCacheListHead);
        }
    }

    @Override
    public void handleEvent(final Object event) {
        IElementUpdateTester elementTester = this.getActiveUpdatePolicy().getTesterTester(event);
        LinkedList<FlushMarkerKey> flushKeys = new LinkedList<FlushMarkerKey>();
        LinkedList<IVMModelProxy> proxies = new LinkedList<IVMModelProxy>();
        for (final IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            if (!proxyStrategy.isDeltaEvent(event)) continue;
            flushKeys.add(new FlushMarkerKey(proxyStrategy.getRootElement(), elementTester));
            proxies.add(proxyStrategy);
        }
        this.flush(flushKeys);
        for (final IVMModelProxy proxyStrategy : proxies) {
            if (proxyStrategy.isDisposed() || !proxyStrategy.isDeltaEvent(event)) continue;
            proxyStrategy.createDelta(event, new DataRequestMonitor<IModelDelta>((Executor)this.getExecutor(), null){

                public void handleCompleted() {
                    if (this.isSuccess()) {
                        proxyStrategy.fireModelChanged((IModelDelta)this.getData());
                    }
                }

                public String toString() {
                    return "Result of a delta for event: '" + event.toString() + "' in VMP: '" + (Object)((Object)this) + "'" + "\n" + ((IModelDelta)this.getData()).toString();
                }
            });
        }
    }

    @Override
    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        assert (this.getExecutor().isInExecutorThread());
        IVMModelProxy proxy = null;
        for (IVMModelProxy next : this.getActiveModelProxies()) {
            if (next != null || !next.getRootElement().equals(element)) continue;
            proxy = next;
        }
        if (proxy == null) {
            proxy = this.createModelProxyStrategy(element);
            this.getActiveModelProxies().add(proxy);
        }
        return proxy;
    }

    protected void rootElementRemovedFromCache(Object rootElement) {
        this.fRootMarkers.remove(rootElement);
        Iterator<IVMModelProxy> proxiesItr = this.getActiveModelProxies().iterator();
        while (proxiesItr.hasNext()) {
            IVMModelProxy proxy = proxiesItr.next();
            if (!proxy.isDisposed() || !proxy.getRootElement().equals(rootElement)) continue;
            proxiesItr.remove();
        }
    }

    private ElementDataKey makeEntryKey(IVMNode node, IViewerUpdate update) {
        Object rootElement = update.getViewerInput();
        block0: for (IVMModelProxy proxy : this.getActiveModelProxies()) {
            Object proxyRoot = proxy.getRootElement();
            if (proxyRoot.equals(update.getViewerInput())) {
                rootElement = proxyRoot;
                break;
            }
            TreePath path = update.getElementPath();
            for (int i = 0; i < path.getSegmentCount(); ++i) {
                if (!proxyRoot.equals(path.getSegment(i))) continue;
                rootElement = proxyRoot;
                break block0;
            }
        }
        return new ElementDataKey(rootElement, node, update.getElement(), update.getElementPath());
    }

    private ElementDataEntry getElementDataEntry(ElementDataKey key) {
        Entry rootMarkerEntry;
        assert (key != null);
        ElementDataEntry entry = (ElementDataEntry)this.fCacheData.get(key);
        if (entry == null) {
            entry = new ElementDataEntry(key);
            this.addEntry(key, entry);
        } else {
            entry.remove();
            entry.insert(this.fCacheListHead);
        }
        RootElementMarkerKey rootMarker = this.fRootMarkers.get(key.fRootElement);
        if (rootMarker == null) {
            rootMarker = new RootElementMarkerKey(key.fRootElement);
            this.fRootMarkers.put(key.fRootElement, rootMarker);
        }
        if ((rootMarkerEntry = this.fCacheData.get(rootMarker)) == null) {
            rootMarkerEntry = new RootElementMarkerEntry(rootMarker);
            this.addEntry(rootMarker, rootMarkerEntry);
        } else {
            rootMarkerEntry.remove();
            rootMarkerEntry.insert(this.fCacheListHead);
        }
        return entry;
    }

    private void addEntry(Object key, Entry entry) {
        this.fCacheData.put(key, entry);
        entry.insert(this.fCacheListHead);
        if (this.fCacheData.size() > 1000) {
            this.fCacheData.remove(this.fCacheListHead.fNext.fKey);
            this.fCacheListHead.fNext.remove();
        }
    }

    @Deprecated
    public void getModelData(IVMNode node, IViewerUpdate update, IDMService service, final IDMContext dmc, final DataRequestMonitor rm, Executor executor) {
        ElementDataKey key = this.makeEntryKey(node, update);
        final ElementDataEntry entry = this.getElementDataEntry(key);
        Object dataOrStatus = entry.fDataOrStatus.get(dmc);
        if (dataOrStatus != null) {
            if (dataOrStatus instanceof IDMData) {
                rm.setData((Object)((IDMData)dataOrStatus));
            } else {
                rm.setStatus((IStatus)dataOrStatus);
            }
            rm.done();
        } else {
            service.getModelData(dmc, (DataRequestMonitor)new DataRequestMonitor<IDMData>(executor, (RequestMonitor)rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        entry.fDataOrStatus.put(dmc, this.getData());
                        rm.setData(this.getData());
                    } else {
                        entry.fDataOrStatus.put(dmc, this.getStatus());
                        rm.setStatus(this.getStatus());
                    }
                    rm.done();
                }
            });
        }
    }

    @Deprecated
    public IDMData getArchivedModelData(IVMNode node, IViewerUpdate update, IDMContext dmc) {
        ElementDataKey key = this.makeEntryKey(node, update);
        ElementDataEntry entry = this.getElementDataEntry(key);
        if (entry.fArchiveData != null) {
            return entry.fArchiveData.get(dmc);
        }
        return null;
    }

    static class ElementDataEntry
    extends Entry {
        Boolean fDirty = false;
        Boolean fHasChildren = null;
        Integer fChildrenCount = null;
        boolean fAllChildrenKnown = false;
        Map<Integer, Object> fChildren = null;
        Map<IDMContext, Object> fDataOrStatus = new HashMap<IDMContext, Object>(1);
        Map<IDMContext, IDMData> fArchiveData = new HashMap<IDMContext, IDMData>(1);

        ElementDataEntry(ElementDataKey key) {
            super(key);
        }

        public String toString() {
            return this.fKey.toString() + " = " + "[hasChildren=" + this.fHasChildren + ", " + "childrenCount=" + this.fChildrenCount + ", children=" + this.fChildren + ", data/status=" + this.fDataOrStatus + ", oldData=" + this.fArchiveData + "]";
        }
    }

    private static class ElementDataKey {
        final Object fRootElement;
        final IVMNode fNode;
        final Object fViewerInput;
        final TreePath fPath;

        ElementDataKey(Object rootElement, IVMNode node, Object viewerInput, TreePath path) {
            this.fRootElement = rootElement;
            this.fNode = node;
            this.fViewerInput = viewerInput;
            this.fPath = path;
        }

        public String toString() {
            return this.fViewerInput + "." + this.fPath.toString() + "(" + this.fNode + ")";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ElementDataKey)) {
                return false;
            }
            ElementDataKey key = (ElementDataKey)obj;
            return (this.fNode == null && key.fNode == null || this.fNode != null && this.fNode.equals(key.fNode)) && (this.fRootElement == null && key.fRootElement == null || this.fRootElement != null && this.fRootElement.equals(key.fRootElement)) && (this.fViewerInput == null && key.fViewerInput == null || this.fViewerInput != null && this.fViewerInput.equals(key.fViewerInput)) && (this.fPath == null && key.fPath == null || this.fPath != null && this.fPath.equals((Object)key.fPath));
        }

        public int hashCode() {
            return (this.fRootElement != null ? this.fRootElement.hashCode() : 0) + (this.fNode != null ? this.fNode.hashCode() : 0) + (this.fViewerInput != null ? this.fViewerInput.hashCode() : 0) + (this.fPath != null ? this.fPath.hashCode() : 0);
        }
    }

    private static class Entry {
        final Object fKey;
        Entry fNext;
        Entry fPrevious;

        Entry(Object key) {
            this.fKey = key;
        }

        void insert(Entry nextEntry) {
            this.fNext = nextEntry;
            this.fPrevious = nextEntry.fPrevious;
            this.fPrevious.fNext = this;
            this.fNext.fPrevious = this;
        }

        void remove() {
            this.fPrevious.fNext = this.fNext;
            this.fNext.fPrevious = this.fPrevious;
        }
    }

    private static class FlushMarkerKey {
        private Object fRootElement;
        private IElementUpdateTester fElementTester;

        FlushMarkerKey(Object rootElement, IElementUpdateTester pathTester) {
            this.fRootElement = rootElement;
            this.fElementTester = pathTester;
        }

        boolean includes(FlushMarkerKey key) {
            return this.fRootElement.equals(key.fRootElement) && this.fElementTester.includes(key.fElementTester);
        }

        int getUpdateFlags(ElementDataKey key) {
            if (this.fRootElement.equals(key.fRootElement)) {
                return this.fElementTester.getUpdateFlags(key.fViewerInput, key.fPath);
            }
            return 0;
        }
    }

    class RootElementMarkerEntry
    extends Entry {
        RootElementMarkerEntry(RootElementMarkerKey key) {
            super(key);
        }

        void remove() {
            super.remove();
            AbstractCachingVMProvider.this.rootElementRemovedFromCache(((RootElementMarkerKey)this.fKey).fRootElement);
        }
    }

    private static class RootElementMarkerKey {
        private Object fRootElement;

        RootElementMarkerKey(Object rootElement) {
            this.fRootElement = rootElement;
        }
    }
}

