/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.concurrent.DisplayDsfExecutor;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.DefaultVMContentProviderStrategy;
import org.eclipse.dd.dsf.ui.viewmodel.DefaultVMModelProxyStrategy;
import org.eclipse.dd.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVMProvider
implements IVMProvider {
    private final AbstractVMAdapter fVMAdapter;
    private final IPresentationContext fPresentationContext;
    private final DsfExecutor fExecutor = DisplayDsfExecutor.getDisplayDsfExecutor(Display.getDefault());
    private final IElementContentProvider fContentStrategy;
    private List<IVMModelProxy> fActiveModelProxies = new LinkedList<IVMModelProxy>();
    private static final IVMNode[] EMPTY_NODES_ARRAY = new IVMNode[0];
    private Map<IVMNode, IVMNode[]> fChildNodesMap = new HashMap<IVMNode, IVMNode[]>();
    private IVMNode[] fNodesListCache = null;
    private boolean fDisposed = false;
    private IRootVMNode fRootNode;
    private Map<IVMModelProxy, ModelProxyEventQueue> fEventQueues = new HashMap<IVMModelProxy, ModelProxyEventQueue>();

    public AbstractVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext) {
        this.fVMAdapter = adapter;
        this.fPresentationContext = presentationContext;
        this.fContentStrategy = this.createContentStrategy();
    }

    @Override
    public IPresentationContext getPresentationContext() {
        return this.fPresentationContext;
    }

    @Override
    public AbstractVMAdapter getVMAdapter() {
        return this.fVMAdapter;
    }

    protected IElementContentProvider createContentStrategy() {
        return new DefaultVMContentProviderStrategy(this);
    }

    protected IElementContentProvider getContentStrategy() {
        return this.fContentStrategy;
    }

    protected IVMModelProxy createModelProxyStrategy(Object rootElement) {
        return new DefaultVMModelProxyStrategy(this, rootElement);
    }

    protected List<IVMModelProxy> getActiveModelProxies() {
        return this.fActiveModelProxies;
    }

    public void handleEvent(Object event) {
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            ModelProxyEventQueue queue;
            if (!proxyStrategy.isDeltaEvent(event)) continue;
            if (!this.fEventQueues.containsKey(proxyStrategy)) {
                this.fEventQueues.put(proxyStrategy, new ModelProxyEventQueue());
            }
            if ((queue = this.fEventQueues.get(proxyStrategy)).fProcessingEvent) {
                if (!queue.fEventQueue.isEmpty()) {
                    Object eventToSkip;
                    ListIterator itr = queue.fEventQueue.listIterator(queue.fEventQueue.size() - 1);
                    while (itr.hasPrevious() && this.canSkipHandlingEvent(event, eventToSkip = itr.previous())) {
                        itr.remove();
                    }
                }
                queue.fEventQueue.add(event);
                continue;
            }
            this.doHandleEvent(queue, proxyStrategy, event);
        }
        List<IVMModelProxy> activeProxies = this.getActiveModelProxies();
        Iterator<IVMModelProxy> itr = this.fEventQueues.keySet().iterator();
        while (itr.hasNext()) {
            if (activeProxies.contains(itr.next())) continue;
            itr.remove();
        }
    }

    private void doHandleEvent(final ModelProxyEventQueue queue, final IVMModelProxy proxyStrategy, Object event) {
        queue.fProcessingEvent = true;
        this.handleEvent(proxyStrategy, event, new RequestMonitor((Executor)this.getExecutor(), null){

            protected void handleCompleted() {
                queue.fProcessingEvent = false;
                if (!queue.fEventQueue.isEmpty()) {
                    AbstractVMProvider.this.doHandleEvent(queue, proxyStrategy, queue.fEventQueue.remove(0));
                }
            }
        });
    }

    protected void handleEvent(final IVMModelProxy proxyStrategy, final Object event, RequestMonitor rm) {
        if (!proxyStrategy.isDisposed()) {
            proxyStrategy.createDelta(event, new DataRequestMonitor<IModelDelta>((Executor)this.getExecutor(), rm){

                public void handleCompleted() {
                    if (this.isSuccess()) {
                        proxyStrategy.fireModelChanged((IModelDelta)this.getData());
                    }
                    super.handleCompleted();
                }

                public String toString() {
                    return "Result of a delta for event: '" + event.toString() + "' in VMP: '" + (Object)((Object)this) + "'" + "\n" + ((IModelDelta)this.getData()).toString();
                }
            });
        } else {
            rm.done();
        }
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        return false;
    }

    @Override
    public IRootVMNode getRootVMNode() {
        return this.fRootNode;
    }

    @Override
    public IVMNode[] getAllVMNodes() {
        if (this.fNodesListCache != null) {
            return this.fNodesListCache;
        }
        ArrayList<IVMNode> list = new ArrayList<IVMNode>();
        for (IVMNode node : this.fChildNodesMap.keySet()) {
            if (node == null) continue;
            list.add(node);
        }
        this.fNodesListCache = list.toArray(new IVMNode[list.size()]);
        return this.fNodesListCache;
    }

    @Override
    public IVMNode[] getChildVMNodes(IVMNode node) {
        IVMNode[] retVal = this.fChildNodesMap.get(node);
        if (retVal != null) {
            return retVal;
        }
        return EMPTY_NODES_ARRAY;
    }

    protected void addChildNodes(IVMNode parentNode, IVMNode[] childNodes) {
        IVMNode[] existingChildNodes = this.fChildNodesMap.get(parentNode);
        if (existingChildNodes == null) {
            this.fChildNodesMap.put(parentNode, childNodes);
        } else {
            IVMNode[] newNodes = new IVMNode[existingChildNodes.length + childNodes.length];
            System.arraycopy(existingChildNodes, 0, newNodes, 0, existingChildNodes.length);
            System.arraycopy(childNodes, 0, newNodes, existingChildNodes.length, childNodes.length);
            this.fChildNodesMap.put(parentNode, newNodes);
        }
        for (IVMNode childNode : childNodes) {
            this.addNode(childNode);
        }
        this.fNodesListCache = null;
    }

    protected void addNode(IVMNode node) {
        if (!this.fChildNodesMap.containsKey(node)) {
            this.fChildNodesMap.put(node, EMPTY_NODES_ARRAY);
        }
    }

    protected void clearNodes() {
        for (IVMNode node : this.fChildNodesMap.keySet()) {
            node.dispose();
        }
        this.fChildNodesMap.clear();
        this.fRootNode = null;
    }

    protected void setRootNode(IRootVMNode rootNode) {
        this.fRootNode = rootNode;
    }

    @Override
    public void dispose() {
        this.clearNodes();
        this.fRootNode = null;
    }

    public void update(IHasChildrenUpdate[] updates) {
        this.fContentStrategy.update(updates);
    }

    public void update(IChildrenCountUpdate[] updates) {
        this.fContentStrategy.update(updates);
    }

    public void update(IChildrenUpdate[] updates) {
        this.fContentStrategy.update(updates);
    }

    @Override
    public void updateNode(final IVMNode node, IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] updateProxies = new IHasChildrenUpdate[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            final IHasChildrenUpdate update = updates[i];
            updateProxies[i] = new VMHasChildrenUpdate((IViewerUpdate)update, (DataRequestMonitor<Boolean>)new ViewerDataRequestMonitor<Boolean>((Executor)this.getExecutor(), (IViewerUpdate)updates[i]){

                @Override
                protected void handleSuccess() {
                    update.setHasChilren(((Boolean)this.getData()).booleanValue());
                    update.done();
                }

                @Override
                protected void handleErrorOrWarning() {
                    if (this.getStatus().getCode() == 10003) {
                        AbstractVMProvider.this.updateNode(node, new VMChildrenUpdate((IViewerUpdate)update, -1, -1, (DataRequestMonitor<List<Object>>)new ViewerDataRequestMonitor<List<Object>>((Executor)AbstractVMProvider.this.getExecutor(), (IViewerUpdate)update){

                            @Override
                            protected void handleSuccess() {
                                update.setHasChilren(!((List)this.getData()).isEmpty());
                                update.done();
                            }
                        }));
                    } else {
                        update.setStatus(this.getStatus());
                        update.done();
                    }
                }
            });
        }
        node.update(updateProxies);
    }

    @Override
    public void updateNode(final IVMNode node, final IChildrenCountUpdate update) {
        node.update(new IChildrenCountUpdate[]{new VMChildrenCountUpdate((IViewerUpdate)update, (DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>((Executor)this.getExecutor(), (IViewerUpdate)update){

            @Override
            protected void handleSuccess() {
                update.setChildCount(((Integer)this.getData()).intValue());
                update.done();
            }

            @Override
            protected void handleErrorOrWarning() {
                if (this.getStatus().getCode() == 10003) {
                    AbstractVMProvider.this.updateNode(node, new VMChildrenUpdate((IViewerUpdate)update, -1, -1, (DataRequestMonitor<List<Object>>)new ViewerDataRequestMonitor<List<Object>>((Executor)AbstractVMProvider.this.getExecutor(), (IViewerUpdate)update){

                        @Override
                        protected void handleSuccess() {
                            update.setChildCount(((List)this.getData()).size());
                            update.done();
                        }
                    }));
                }
            }
        })});
    }

    @Override
    public void updateNode(IVMNode node, IChildrenUpdate update) {
        node.update(new IChildrenUpdate[]{update});
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public DsfExecutor getExecutor() {
        return this.fExecutor;
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        assert (this.getExecutor().isInExecutorThread());
        IVMModelProxy proxy = null;
        Iterator<IVMModelProxy> itr = this.getActiveModelProxies().iterator();
        while (itr.hasNext()) {
            IVMModelProxy next = itr.next();
            if (next == null && next.getRootElement().equals(element)) {
                proxy = next;
                continue;
            }
            if (!next.isDisposed()) continue;
            itr.remove();
        }
        if (proxy == null) {
            proxy = this.createModelProxyStrategy(element);
            this.getActiveModelProxies().add(proxy);
        }
        return proxy;
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        assert (this.fExecutor.isInExecutorThread());
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return null;
    }

    public void update(IViewerInputUpdate update) {
        update.setInputElement(update.getElement());
        update.done();
    }

    private class ModelProxyEventQueue {
        private boolean fProcessingEvent = false;
        private List<Object> fEventQueue = new LinkedList<Object>();

        private ModelProxyEventQueue() {
        }
    }
}

