/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.ui.viewmodel.VMViewerUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.dd.dsf.ui.viewmodel.properties.ILabelAttributeChangedListener;
import org.eclipse.dd.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class PropertyBasedLabelProvider
implements IElementLabelProvider,
ILabelAttributeChangedListener {
    private static final String[] EMPTY_PROPERTY_NAMES_ARRAY = new String[0];
    private Map<String, LabelColumnInfo> fColumnInfos = Collections.synchronizedMap(new HashMap());
    private ListenerList fListeners = new ListenerList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LabelColumnInfo[] infos = null;
        Map<String, LabelColumnInfo> map = this.fColumnInfos;
        synchronized (map) {
            infos = this.fColumnInfos.values().toArray(new LabelColumnInfo[this.fColumnInfos.size()]);
            this.fColumnInfos.clear();
        }
        for (LabelColumnInfo info : infos) {
            info.dispose();
        }
    }

    public LabelColumnInfo setColumnInfo(String columnId, LabelColumnInfo info) {
        LabelColumnInfo oldInfo = this.fColumnInfos.put(columnId, info);
        info.addChangedListener(this);
        if (oldInfo != null) {
            info.removeChangedListener(this);
        }
        return oldInfo;
    }

    public LabelColumnInfo getColumnInfo(String column) {
        return this.fColumnInfos.get(column);
    }

    public void addChangedListener(ILabelAttributeChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeChangedListener(ILabelAttributeChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void attributesChanged() {
        Object[] listeners;
        for (Object listener : listeners = this.fListeners.getListeners()) {
            ((ILabelAttributeChangedListener)listener).attributesChanged();
        }
    }

    public void update(ILabelUpdate[] labelUpdates) {
        IElementPropertiesProvider propertiesProvider = this.getElementPropertiesProvider(labelUpdates[0].getElement());
        if (propertiesProvider == null) {
            for (ILabelUpdate update : labelUpdates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", "Properties-based label provider " + this + " failed to generate a label, no properties provider registered for element: " + labelUpdates[0].getElement()));
                update.done();
            }
            return;
        }
        String[] columnIds = labelUpdates[0].getColumnIds();
        String[] propertyNames = this.calcPropertyNamesForColumns(columnIds);
        IPropertiesUpdate[] propertiesUpdates = new IPropertiesUpdate[labelUpdates.length];
        for (int i = 0; i < labelUpdates.length; ++i) {
            final ILabelUpdate labelUpdate = labelUpdates[i];
            propertiesUpdates[i] = new PropertiesUpdate(propertyNames, labelUpdates[i], new DataRequestMonitor<Map<String, Object>>(ImmediateExecutor.getInstance(), null){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        PropertyBasedLabelProvider.this.updateLabel(labelUpdate, (Map)this.getData());
                    }
                    labelUpdate.done();
                }
            });
        }
        propertiesProvider.update(propertiesUpdates);
    }

    private String[] calcPropertyNamesForColumns(String[] columnIds) {
        if (columnIds == null) {
            LabelColumnInfo columnInfo = this.getColumnInfo(null);
            if (columnInfo != null) {
                return columnInfo.getPropertyNames();
            }
            return EMPTY_PROPERTY_NAMES_ARRAY;
        }
        LinkedList<String> properties = new LinkedList<String>();
        for (String columnId : columnIds) {
            LabelColumnInfo info = this.getColumnInfo(columnId);
            if (info == null) continue;
            String[] infoPropertyNames = info.getPropertyNames();
            for (int i = 0; i < infoPropertyNames.length; ++i) {
                properties.add(infoPropertyNames[i]);
            }
        }
        return properties.toArray(new String[properties.size()]);
    }

    protected void updateLabel(ILabelUpdate update, Map<String, Object> properties) {
        if (update.getColumnIds() == null) {
            LabelColumnInfo info = this.getColumnInfo(null);
            if (info != null) {
                info.updateColumn(update, 0, properties);
            }
        } else {
            String[] columnIds = update.getColumnIds();
            for (int i = 0; i < columnIds.length; ++i) {
                LabelColumnInfo info = this.getColumnInfo(columnIds[i]);
                if (info == null) continue;
                info.updateColumn(update, i, properties);
            }
        }
        update.done();
    }

    private IElementPropertiesProvider getElementPropertiesProvider(Object element) {
        if (element instanceof IAdaptable) {
            return (IElementPropertiesProvider)((IAdaptable)element).getAdapter(IElementPropertiesProvider.class);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesUpdate
    extends VMViewerUpdate
    implements IPropertiesUpdate {
        private final String[] fProperties;
        private final Map<String, Object> fValues;

        public PropertiesUpdate(String[] properties, ILabelUpdate labelUpdate, DataRequestMonitor<Map<String, Object>> rm) {
            super((IViewerUpdate)labelUpdate, (RequestMonitor)rm);
            this.fProperties = properties;
            this.fValues = this.fProperties != null ? new HashMap(properties.length * 4 / 3, 0.75f) : new HashMap();
        }

        @Override
        public String[] getProperties() {
            return this.fProperties;
        }

        @Override
        public void setProperty(String property, Object value) {
            this.fValues.put(property, value);
        }

        @Override
        public void done() {
            DataRequestMonitor rm = (DataRequestMonitor)this.getRequestMonitor();
            if (this.fProperties == null || this.fValues.size() >= this.fProperties.length) {
                rm.setData(this.fValues);
            } else {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10004, "Incomplete properties updated", null));
            }
            super.done();
        }
    }
}

