/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.update;

import java.util.Set;
import org.eclipse.dd.dsf.ui.viewmodel.update.IElementUpdateTester;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.ViewModelUpdateMessages;
import org.eclipse.jface.viewers.TreePath;

public class ManualUpdatePolicy
implements IVMUpdatePolicy {
    public static String MANUAL_UPDATE_POLICY_ID = "org.eclipse.dd.dsf.ui.viewmodel.update.manualUpdatePolicy";
    public static Object REFRESH_EVENT = new Object();
    private static IElementUpdateTester fgUpdateTester = new IElementUpdateTester(){

        public int getUpdateFlags(Object viewerInput, TreePath path) {
            return 4;
        }

        public boolean includes(IElementUpdateTester tester) {
            return tester.equals(this);
        }
    };
    private static IElementUpdateTester fgRefreshUpdateTester = new IElementUpdateTester(){

        public int getUpdateFlags(Object viewerInput, TreePath path) {
            return 3;
        }

        public boolean includes(IElementUpdateTester tester) {
            return tester.equals(this) || tester.equals(fgUpdateTester) || tester instanceof UserEditEventUpdateTester;
        }
    };

    public String getID() {
        return MANUAL_UPDATE_POLICY_ID;
    }

    public String getName() {
        return ViewModelUpdateMessages.ManualUpdatePolicy_name;
    }

    public IElementUpdateTester getElementUpdateTester(Object event) {
        if (event.equals(REFRESH_EVENT)) {
            return fgRefreshUpdateTester;
        }
        return fgUpdateTester;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserEditEventUpdateTester
    implements IElementUpdateTester {
        private final Set<Object> fElements;

        public UserEditEventUpdateTester(Set<Object> elements) {
            this.fElements = elements;
        }

        @Override
        public int getUpdateFlags(Object viewerInput, TreePath path) {
            if (this.fElements.contains(viewerInput)) {
                return 1;
            }
            for (int i = 0; i < path.getSegmentCount(); ++i) {
                if (!this.fElements.contains(path.getSegment(i))) continue;
                return 1;
            }
            return 0;
        }

        @Override
        public boolean includes(IElementUpdateTester tester) {
            return tester instanceof UserEditEventUpdateTester && ((Object)this.fElements).equals(((UserEditEventUpdateTester)tester).fElements);
        }
    }
}

