/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.concurrent;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.DsfPlugin;
import org.eclipse.dd.dsf.concurrent.DsfExecutable;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.StackTraceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDsfExecutor
extends ScheduledThreadPoolExecutor
implements DsfExecutor {
    static boolean DEBUG_EXECUTOR = false;
    static boolean ASSERTIONS_ENABLED = false;
    static Map<Thread, DefaultDsfExecutor> fThreadToExecutorMap;
    TracingWrapper fCurrentlyExecuting;
    int fSequenceCounter;

    public DefaultDsfExecutor() {
        super(1, new DsfThreadFactory());
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            this.prestartAllCoreThreads();
            fThreadToExecutorMap.put(((DsfThreadFactory)this.getThreadFactory()).fThread, this);
        }
    }

    @Override
    public boolean isInExecutorThread() {
        return Thread.currentThread().equals(((DsfThreadFactory)this.getThreadFactory()).fThread);
    }

    static void logException(Throwable t) {
        DsfPlugin plugin = DsfPlugin.getDefault();
        if (plugin == null) {
            return;
        }
        ILog log = plugin.getLog();
        if (log != null) {
            log.log((IStatus)new Status(4, "org.eclipse.dd.dsf", -1, "Uncaught exception in DSF executor thread", t));
        }
        if (ASSERTIONS_ENABLED) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(512);
            PrintStream printStream = new PrintStream(outStream);
            try {
                printStream.write("Uncaught exception in session executor thread: ".getBytes());
            }
            catch (IOException e2) {
                // empty catch block
            }
            t.printStackTrace(new PrintStream(outStream));
            System.err.println(outStream.toString());
        }
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if ((DEBUG_EXECUTOR || ASSERTIONS_ENABLED) && !(callable instanceof TracingWrapper)) {
            callable = new TracingWrapperCallable<V>(callable, 6);
        }
        return super.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if ((DEBUG_EXECUTOR || ASSERTIONS_ENABLED) && !(command instanceof TracingWrapper)) {
            command = new TracingWrapperRunnable(command, 6);
        }
        return super.schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command, 6);
        }
        return super.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command, 6);
        }
        return super.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command, 6);
        }
        super.execute(command);
    }

    @Override
    public Future<?> submit(Runnable command) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command, 6);
        }
        return super.submit(command);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            callable = new TracingWrapperCallable<T>(callable, 6);
        }
        return super.submit(callable);
    }

    @Override
    public <T> Future<T> submit(Runnable command, T result) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command, 6);
        }
        return super.submit(command, result);
    }

    static {
        boolean bl = DEBUG_EXECUTOR = DsfPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.dd.dsf/debug/executor"));
        if (!$assertionsDisabled) {
            ASSERTIONS_ENABLED = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        fThreadToExecutorMap = new HashMap<Thread, DefaultDsfExecutor>();
    }

    static class DsfThreadFactory
    implements ThreadFactory {
        Thread fThread;

        DsfThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            assert (this.fThread == null);
            this.fThread = new Thread(new ThreadGroup("DSF Thread Group"), r, "DSF Dispatch Thread", 0L);
            return this.fThread;
        }
    }

    abstract class TracingWrapper {
        int fSequenceNumber = -1;
        StackTraceWrapper fSubmittedAt = null;
        TracingWrapper fSubmittedBy = null;

        TracingWrapper(int offset) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.fSubmittedAt = new StackTraceWrapper(new StackTraceElement[stackTrace.length - offset]);
            System.arraycopy(stackTrace, offset - 1, this.fSubmittedAt.fStackTraceElements, 0, this.fSubmittedAt.fStackTraceElements.length);
            if (DefaultDsfExecutor.this.isInExecutorThread() && DefaultDsfExecutor.this.fCurrentlyExecuting != null) {
                this.fSubmittedBy = DefaultDsfExecutor.this.fCurrentlyExecuting;
            }
        }

        void traceExecution() {
            this.fSequenceNumber = DefaultDsfExecutor.this.fSequenceCounter++;
            DefaultDsfExecutor.this.fCurrentlyExecuting = this;
            if (DEBUG_EXECUTOR) {
                StringBuilder traceBuilder = new StringBuilder();
                traceBuilder.append(DsfPlugin.getDebugTime());
                traceBuilder.append(' ');
                traceBuilder.append('#');
                traceBuilder.append(this.fSequenceNumber);
                traceBuilder.append(' ');
                traceBuilder.append(this.getExecutable().getClass().getName());
                traceBuilder.append("\n        ");
                traceBuilder.append(this.getExecutable().toString());
                if (this.getExecutable() instanceof DsfExecutable) {
                    DsfExecutable dsfExecutable = (DsfExecutable)this.getExecutable();
                    if (dsfExecutable.fCreatedAt != null || dsfExecutable.fCreatedBy != null) {
                        traceBuilder.append("\n            created  ");
                        if (dsfExecutable.fCreatedBy != null) {
                            traceBuilder.append(" by #");
                            traceBuilder.append(dsfExecutable.fCreatedBy.fSequenceNumber);
                        }
                        if (dsfExecutable.fCreatedAt != null) {
                            traceBuilder.append("\n                      at ");
                            traceBuilder.append(dsfExecutable.fCreatedAt.fStackTraceElements[0].toString());
                            for (int i = 1; i < dsfExecutable.fCreatedAt.fStackTraceElements.length && i < 3; ++i) {
                                traceBuilder.append("\n                         ");
                                traceBuilder.append(dsfExecutable.fCreatedAt.fStackTraceElements[i].toString());
                            }
                        }
                    }
                }
                traceBuilder.append("\n            submitted");
                if (this.fSubmittedBy != null) {
                    traceBuilder.append(" by #");
                    traceBuilder.append(this.fSubmittedBy.fSequenceNumber);
                }
                traceBuilder.append("\n                      at ");
                traceBuilder.append(this.fSubmittedAt.fStackTraceElements[0].toString());
                for (int i = 1; i < this.fSubmittedAt.fStackTraceElements.length && i < 3; ++i) {
                    traceBuilder.append("\n                         ");
                    traceBuilder.append(this.fSubmittedAt.fStackTraceElements[i].toString());
                }
                traceBuilder.append(" at ");
                traceBuilder.append(this.fSubmittedAt.fStackTraceElements[0].toString());
                DsfPlugin.debug(traceBuilder.toString());
            }
        }

        protected abstract Object getExecutable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TracingWrapperCallable<T>
    extends TracingWrapper
    implements Callable<T> {
        final Callable<T> fCallable;

        public TracingWrapperCallable(Callable<T> callable, int offset) {
            super(offset);
            if (callable == null) {
                throw new NullPointerException();
            }
            this.fCallable = callable;
        }

        @Override
        protected Object getExecutable() {
            return this.fCallable;
        }

        @Override
        public T call() throws Exception {
            this.traceExecution();
            return this.fCallable.call();
        }
    }

    class TracingWrapperRunnable
    extends TracingWrapper
    implements Runnable {
        final Runnable fRunnable;

        public TracingWrapperRunnable(Runnable runnable, int offset) {
            super(offset);
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.fRunnable = runnable;
            if (DEBUG_EXECUTOR && this.fRunnable instanceof DsfExecutable) {
                assert (!((DsfExecutable)((Object)this.fRunnable)).getSubmitted()) : "Executable was previously executed.";
                ((DsfExecutable)((Object)this.fRunnable)).setSubmitted();
            }
        }

        protected Object getExecutable() {
            return this.fRunnable;
        }

        public void run() {
            this.traceExecution();
            try {
                this.fRunnable.run();
            }
            catch (RuntimeException e) {
                DefaultDsfExecutor.logException(e);
                throw e;
            }
        }
    }
}

