/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.concurrent;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRequestMonitor<V extends RequestMonitor>
extends RequestMonitor {
    private List<V> fRequestMonitorList = new LinkedList<V>();
    private Map<V, Boolean> fStatusMap = new HashMap<V, Boolean>();
    private int fDoneCounter;

    public MultiRequestMonitor(Executor executor, RequestMonitor parentRequestMonitor) {
        super(executor, parentRequestMonitor);
        this.setStatus((IStatus)new MultiStatus("org.eclipse.dd.dsf", 0, "Collective status for set of sub-operations.", null));
    }

    public <T extends V> T add(T rm) {
        assert (!this.fStatusMap.containsKey(rm));
        this.fRequestMonitorList.add(rm);
        this.fStatusMap.put((Boolean)rm, false);
        ++this.fDoneCounter;
        return rm;
    }

    public void requestMonitorDone(V requestMonitor) {
        ((MultiStatus)this.getStatus()).merge(((RequestMonitor)requestMonitor).getStatus());
        assert (this.fStatusMap.containsKey(requestMonitor));
        this.fStatusMap.put((Boolean)requestMonitor, true);
        assert (this.fDoneCounter > 0);
        --this.fDoneCounter;
        if (this.fDoneCounter == 0) {
            assert (!this.fStatusMap.containsValue(false));
            super.done();
        }
    }

    public List<V> getRequestMonitors() {
        return this.fRequestMonitorList;
    }

    public boolean isRequestMonitorDone(V rm) {
        return this.fStatusMap.get(rm);
    }

    @Override
    public String toString() {
        return "Multi-RequestMonitor: " + this.getStatus().toString();
    }
}

