/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.DsfPlugin;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;

@ConfinedToDsfExecutor(value="")
public class RequestMonitor {
    public static final IStatus STATUS_CANCEL = new Status(8, "org.eclipse.dd.dsf", "Request canceled");
    private final Executor fExecutor;
    private final RequestMonitor fParentRequestMonitor;
    private IStatus fStatus = Status.OK_STATUS;
    private boolean fCanceled = false;
    private boolean fDone = false;

    public RequestMonitor(Executor executor, RequestMonitor parentRequestMonitor) {
        this.fExecutor = executor;
        this.fParentRequestMonitor = parentRequestMonitor;
    }

    public synchronized void setStatus(IStatus status) {
        this.fStatus = status;
    }

    public synchronized IStatus getStatus() {
        return this.fStatus;
    }

    public synchronized void setCanceled(boolean canceled) {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setCanceled(canceled);
        } else {
            this.fCanceled = canceled;
        }
    }

    public synchronized boolean isCanceled() {
        if (this.fParentRequestMonitor != null) {
            return this.fParentRequestMonitor.isCanceled();
        }
        return this.fCanceled;
    }

    public synchronized void done() {
        if (this.fDone) {
            throw new IllegalStateException("RequestMonitor: " + this + ", done() method called more than once");
        }
        this.fDone = true;
        try {
            this.fExecutor.execute(new DsfRunnable(){

                public void run() {
                    RequestMonitor.this.handleCompleted();
                }

                public String toString() {
                    return "Completed: " + RequestMonitor.this.toString();
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.handleRejectedExecutionException();
        }
    }

    public String toString() {
        return "RequestMonitor: " + this.getStatus().toString();
    }

    protected void handleCompleted() {
        if (this.getStatus().isOK()) {
            this.handleOK();
        } else {
            this.handleErrorOrCancel();
        }
    }

    protected void handleOK() {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.done();
        }
    }

    protected void handleErrorOrCancel() {
        assert (!this.getStatus().isOK());
        if (this.isCanceled()) {
            this.handleCancel();
        } else {
            if (this.getStatus().getCode() == 8) {
                DsfPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.dd.dsf", 10005, "Request monitor: '" + this + "' resulted in a cancel status: " + this.getStatus() + ", even though the request is not set to cancel.", null));
            }
            this.handleError();
        }
    }

    protected void handleError() {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setStatus(this.getStatus());
            this.fParentRequestMonitor.done();
        } else {
            MultiStatus logStatus = new MultiStatus("org.eclipse.dd.dsf", 10005, "Request for monitor: '" + this.toString() + "' resulted in an error.", null);
            logStatus.merge(this.getStatus());
            DsfPlugin.getDefault().getLog().log((IStatus)logStatus);
        }
    }

    protected void handleCancel() {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setStatus(this.getStatus());
            this.fParentRequestMonitor.done();
        }
    }

    protected void handleRejectedExecutionException() {
        MultiStatus logStatus = new MultiStatus("org.eclipse.dd.dsf", 10005, "Request for monitor: '" + this.toString() + "' resulted in a rejected execution exception.", null);
        logStatus.merge(this.getStatus());
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setStatus((IStatus)logStatus);
            this.fParentRequestMonitor.done();
        } else {
            DsfPlugin.getDefault().getLog().log((IStatus)logStatus);
        }
    }
}

