/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.datamodel;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.service.IDsfService;

@Immutable
public abstract class AbstractDMContext
extends PlatformObject
implements IDMContext {
    private final String fSessionId;
    private final IDMContext[] fParents;

    public AbstractDMContext(String sessionId, IDMContext[] parents) {
        this.fSessionId = sessionId;
        this.fParents = parents;
    }

    public AbstractDMContext(IDsfService service, IDMContext[] parents) {
        this(service.getSession().getId(), parents);
    }

    protected boolean baseEquals(Object other) {
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        IDMContext otherCtx = (IDMContext)other;
        return this.getSessionId().equals(otherCtx.getSessionId()) && this.areParentsEqual(otherCtx.getParents());
    }

    private boolean areParentsEqual(IDMContext[] otherParents) {
        if (this.fParents.length != otherParents.length) {
            return false;
        }
        for (int i = 0; i < this.fParents.length; ++i) {
            if (this.fParents[i].equals(otherParents[i])) continue;
            return false;
        }
        return true;
    }

    protected int baseHashCode() {
        int parentsHash = 0;
        for (IDMContext parent : this.getParents()) {
            parentsHash += parent.hashCode();
        }
        return this.getSessionId().hashCode() + parentsHash;
    }

    protected String baseToString() {
        StringBuffer retVal = new StringBuffer();
        for (IDMContext parent : this.fParents) {
            retVal.append(parent);
        }
        return retVal.toString();
    }

    public String getSessionId() {
        return this.fSessionId;
    }

    public IDMContext[] getParents() {
        return this.fParents;
    }

    public Object getAdapter(Class adapterType) {
        Object retVal = null;
        DsfSession session = DsfSession.getSession(this.fSessionId);
        if (session != null) {
            retVal = session.getModelAdapter(adapterType);
        }
        if (retVal == null) {
            retVal = super.getAdapter(adapterType);
        }
        return retVal;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

