/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.service;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.service.IDsfService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractDsfService
implements IDsfService {
    private DsfSession fSession;
    private int fStartupNumber;
    private ServiceRegistration fRegistration;
    private DsfServicesTracker fTracker;
    private Dictionary fProperties;
    private String fFilter;

    public AbstractDsfService(DsfSession session) {
        this.fSession = session;
    }

    public DsfExecutor getExecutor() {
        return this.fSession.getExecutor();
    }

    public Dictionary getProperties() {
        return this.fProperties;
    }

    public String getServiceFilter() {
        return this.fFilter;
    }

    public int getStartupNumber() {
        return this.fStartupNumber;
    }

    public void initialize(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(this.getBundleContext(), this.fSession.getId());
        this.fStartupNumber = this.fSession.getAndIncrementServiceStartupCounter();
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.fTracker.dispose();
        this.fTracker = null;
        rm.done();
    }

    public DsfSession getSession() {
        return this.fSession;
    }

    protected abstract BundleContext getBundleContext();

    protected DsfServicesTracker getServicesTracker() {
        return this.fTracker;
    }

    protected void register(String[] classes, Dictionary properties) {
        String[] newClasses;
        if (!Arrays.asList(classes).contains(IDsfService.class.getName())) {
            newClasses = new String[classes.length + 1];
            System.arraycopy(classes, 0, newClasses, 1, classes.length);
            newClasses[0] = IDsfService.class.getName();
            classes = newClasses;
        }
        if (!Arrays.asList(classes).contains(this.getClass().getName())) {
            newClasses = new String[classes.length + 1];
            System.arraycopy(classes, 0, newClasses, 1, classes.length);
            newClasses[0] = this.getClass().getName();
            classes = newClasses;
        }
        properties.put("org.eclipse.dd.dsf.service.IService.session_id", this.getSession().getId());
        this.fProperties = properties;
        this.fRegistration = this.getBundleContext().registerService(classes, (Object)this, properties);
        this.fRegistration.getReference().getProperty("objectClass");
        this.fProperties.put("objectClass", this.fRegistration.getReference().getProperty("objectClass"));
        this.fFilter = this.generateFilter(this.fProperties);
    }

    private String generateFilter(Dictionary properties) {
        StringBuffer filter = new StringBuffer();
        filter.append("(&");
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = properties.get(key);
            if (value instanceof Object[]) {
                for (Object arrayValue : (Object[])value) {
                    filter.append('(');
                    filter.append(key.toString());
                    filter.append("=*");
                    filter.append(arrayValue.toString());
                    filter.append(')');
                }
                continue;
            }
            filter.append('(');
            filter.append(key.toString());
            filter.append('=');
            filter.append(value.toString());
            filter.append(')');
        }
        filter.append(')');
        return filter.toString();
    }

    protected void unregister() {
        this.fRegistration.unregister();
    }

    protected ServiceRegistration getServiceRegistration() {
        return this.fRegistration;
    }
}

