/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class Query<V>
extends DsfRunnable
implements Future<V> {
    private final Sync fSync = new Sync();

    @Deprecated
    public Query(DsfExecutor executor) {
    }

    public Query() {
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.fSync.doGet();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.fSync.doGet(unit.toNanos(timeout));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.fSync.doCancel();
    }

    @Override
    public boolean isCancelled() {
        return this.fSync.doIsCancelled();
    }

    @Override
    public boolean isDone() {
        return this.fSync.doIsDone();
    }

    protected void doneException(Throwable t) {
        this.fSync.doSetException(t);
    }

    protected abstract void execute(DataRequestMonitor<V> var1);

    @Override
    public void run() {
        if (this.fSync.doRun()) {
            try {
                this.execute(new DataRequestMonitor<V>(ImmediateExecutor.getInstance(), null){

                    @Override
                    public void handleCompleted() {
                        if (this.getStatus().isOK()) {
                            Query.this.fSync.doSet(this.getData());
                        } else {
                            Query.this.fSync.doSetException((Throwable)new CoreException(this.getStatus()));
                        }
                    }
                });
            }
            catch (Throwable t) {
                this.fSync.doSetException(t);
                DefaultDsfExecutor.logException(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int STATE_RUNNING = 1;
        private static final int STATE_DONE = 2;
        private static final int STATE_CANCELLED = 4;
        private V fResult;
        private Throwable fException;

        Sync() {
        }

        private boolean ranOrCancelled(int state) {
            return (state & 6) != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.doIsDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            return true;
        }

        boolean doIsCancelled() {
            return this.getState() == 4;
        }

        boolean doIsDone() {
            return this.ranOrCancelled(this.getState());
        }

        V doGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.fException != null) {
                throw new ExecutionException(this.fException);
            }
            return this.fResult;
        }

        V doGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.fException != null) {
                throw new ExecutionException(this.fException);
            }
            return this.fResult;
        }

        void doSet(V v) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return;
            } while (!this.compareAndSetState(s, 2));
            this.fResult = v;
            this.releaseShared(0);
        }

        void doSetException(Throwable t) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return;
            } while (!this.compareAndSetState(s, 2));
            this.fException = t;
            this.fResult = null;
            this.releaseShared(0);
        }

        boolean doCancel() {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(s, 4));
            this.releaseShared(0);
            return true;
        }

        boolean doRun() {
            return this.compareAndSetState(0, 1);
        }
    }
}

