/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfServicesTracker {
    private BundleContext fBundleContext;
    private Map<ServiceKey, ServiceReference> fServiceReferences = new HashMap<ServiceKey, ServiceReference>();
    private Map<ServiceReference, Object> fServices = new HashMap<ServiceReference, Object>();
    private String fServiceFilter;

    private static String getServiceFilter(String sessionId) {
        return ("(org.eclipse.dd.dsf.service.IService.session_id=" + sessionId + ")").intern();
    }

    public DsfServicesTracker(BundleContext bundleContext, String sessionId) {
        this.fBundleContext = bundleContext;
        this.fServiceFilter = DsfServicesTracker.getServiceFilter(sessionId);
    }

    public ServiceReference getServiceReference(Class serviceClass, String filter) {
        ServiceKey key = new ServiceKey(serviceClass, filter != null ? filter : this.fServiceFilter);
        if (this.fServiceReferences.containsKey(key)) {
            return this.fServiceReferences.get(key);
        }
        try {
            ServiceReference[] references = this.fBundleContext.getServiceReferences(key.fClassName, key.fFilter);
            assert (references == null || references.length <= 1);
            if (references == null || references.length == 0) {
                return null;
            }
            this.fServiceReferences.put(key, references[0]);
            return references[0];
        }
        catch (InvalidSyntaxException e) {
            assert (false) : "Invalid session ID syntax";
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        return null;
    }

    public <V> V getService(Class<V> serviceClass) {
        return this.getService(serviceClass, null);
    }

    public <V> V getService(Class<V> serviceClass, String filter) {
        ServiceReference serviceRef = this.getServiceReference(serviceClass, filter);
        if (serviceRef == null) {
            return null;
        }
        if (this.fServices.containsKey(serviceRef)) {
            return (V)this.fServices.get(serviceRef);
        }
        Object service = this.fBundleContext.getService(serviceRef);
        this.fServices.put(serviceRef, service);
        return (V)service;
    }

    public void dispose() {
        Iterator<ServiceReference> itr = this.fServices.keySet().iterator();
        while (itr.hasNext()) {
            this.fBundleContext.ungetService(itr.next());
            itr.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceKey {
        String fClassName;
        String fFilter;

        public ServiceKey(Class<?> clazz, String filter) {
            this.fClassName = clazz != null ? clazz.getName() : null;
            this.fFilter = filter;
        }

        public boolean equals(Object other) {
            return other instanceof ServiceKey && (this.fClassName == null && ((ServiceKey)other).fClassName == null || this.fClassName != null && this.fClassName.equals(((ServiceKey)other).fClassName)) && (this.fFilter == null && ((ServiceKey)other).fFilter == null || this.fFilter != null && this.fFilter.equals(((ServiceKey)other).fFilter));
        }

        public int hashCode() {
            return (this.fClassName == null ? 0 : this.fClassName.hashCode()) + (this.fFilter == null ? 0 : this.fFilter.hashCode());
        }
    }
}

