/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.viewmodel.launch;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.gdb.internal.provisional.service.GDBRunControl;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControlDMContext;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.MIControlDMContext;
import org.eclipse.dd.mi.service.command.events.MIInferiorExitEvent;
import org.eclipse.dd.mi.service.command.events.MIInferiorSignalExitEvent;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;

public class ContainerVMNode
extends AbstractDMVMNode
implements IElementLabelProvider {
    public ContainerVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IExecutionDMContext.class);
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        if (!this.checkService(AbstractMIControl.class, null, (IViewerUpdate)update)) {
            return;
        }
        MIControlDMContext containerCtx = ((AbstractMIControl)this.getServicesTracker().getService(AbstractMIControl.class)).getControlDMContext();
        update.setChild((Object)this.createVMContext((IDMContext)containerCtx), 0);
        update.done();
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    ContainerVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            if (!this.checkService(GDBRunControl.class, null, (IViewerUpdate)update)) continue;
            GDBRunControl runControl = (GDBRunControl)this.getServicesTracker().getService(GDBRunControl.class);
            GDBControlDMContext dmc = (GDBControlDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), GDBControlDMContext.class);
            String imageKey = null;
            imageKey = runControl.isSuspended((IRunControl.IExecutionDMContext)dmc) ? "IMG_OBJS_THREAD_SUSPENDED" : "IMG_OBJS_THREAD_RUNNING";
            update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
            runControl.getProcessData(dmc, (DataRequestMonitor)new DataRequestMonitor<GDBRunControl.GDBProcessData>((Executor)this.getExecutor(), null){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        update.done();
                        return;
                    }
                    update.setLabel(((GDBRunControl.GDBProcessData)this.getData()).getName(), 0);
                    update.done();
                }
            });
        }
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.IStartedDMEvent || e instanceof IRunControl.IExitedDMEvent) {
            return 1024;
        }
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof GDBControl.ExitedEvent || e instanceof MIInferiorExitEvent || e instanceof MIInferiorSignalExitEvent) {
            return 1024;
        }
        if (e instanceof GDBControl.StartedEvent) {
            return 0x300000;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IDMEvent)e).getDMContext()), 1024);
        } else if (e instanceof IRunControl.IStartedDMEvent || e instanceof IRunControl.IExitedDMEvent) {
            IRunControl.IContainerDMContext containerCtx = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMEvent)e).getDMContext(), IRunControl.IContainerDMContext.class);
            if (containerCtx != null) {
                parentDelta.addNode((Object)this.createVMContext((IDMContext)containerCtx), 1024);
            }
        } else if (e instanceof GDBControl.ExitedEvent || e instanceof MIInferiorExitEvent || e instanceof MIInferiorSignalExitEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IDMEvent)e).getDMContext()), 1024);
        }
        if (e instanceof GDBControl.StartedEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IDMEvent)e).getDMContext()), 0x300000);
        }
        requestMonitor.done();
    }
}

