/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.ui.actions.DsfResumeCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfStepIntoCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfStepOverCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfStepReturnCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfSuspendCommand;
import org.eclipse.dd.dsf.debug.ui.contexts.DsfSuspendTrigger;
import org.eclipse.dd.dsf.debug.ui.sourcelookup.MISourceDisplayAdapter;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.ui.actions.DsfTerminateCommand;
import org.eclipse.dd.gdb.internal.ui.viewmodel.GdbViewModelAdapter;
import org.eclipse.dd.gdb.launching.GdbLaunch;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;

@ThreadSafe
public class GdbAdapterFactory
implements IAdapterFactory,
ILaunchesListener2 {
    private Map<GdbLaunch, SessionAdapterSet> fLaunchAdapterSets = Collections.synchronizedMap(new HashMap());

    public GdbAdapterFactory() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        SessionAdapterSet adapterSet;
        if (!(adaptableObject instanceof GdbLaunch)) {
            return null;
        }
        GdbLaunch launch = (GdbLaunch)adaptableObject;
        DsfSession session = launch.getSession();
        if (session == null) {
            return null;
        }
        Map<GdbLaunch, SessionAdapterSet> map = this.fLaunchAdapterSets;
        synchronized (map) {
            adapterSet = this.fLaunchAdapterSets.get(launch);
            if (adapterSet == null) {
                adapterSet = new SessionAdapterSet(launch);
                this.fLaunchAdapterSets.put(launch, adapterSet);
            }
        }
        if (adapterType.equals(IElementContentProvider.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IModelProxyFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IColumnPresentationFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(ISuspendTrigger.class)) {
            return adapterSet.fSuspendTrigger;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IElementContentProvider.class, IModelProxyFactory.class, ISuspendTrigger.class, IColumnPresentationFactory.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchesRemoved(ILaunch[] launches) {
        for (ILaunch launch : launches) {
            if (!(launch instanceof GdbLaunch)) continue;
            Map<GdbLaunch, SessionAdapterSet> map = this.fLaunchAdapterSets;
            synchronized (map) {
                if (this.fLaunchAdapterSets.containsKey(launch)) {
                    this.fLaunchAdapterSets.remove(launch).dispose();
                }
            }
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    @Immutable
    class SessionAdapterSet {
        final GdbLaunch fLaunch;
        final GdbViewModelAdapter fViewModelAdapter;
        final MISourceDisplayAdapter fSourceDisplayAdapter;
        final DsfStepIntoCommand fStepIntoCommand;
        final DsfStepOverCommand fStepOverCommand;
        final DsfStepReturnCommand fStepReturnCommand;
        final DsfSuspendCommand fSuspendCommand;
        final DsfResumeCommand fResumeCommand;
        final DsfTerminateCommand fTerminateCommand;
        final IDebugModelProvider fDebugModelProvider;
        final DsfSuspendTrigger fSuspendTrigger;

        SessionAdapterSet(GdbLaunch launch) {
            this.fLaunch = launch;
            DsfSession session = launch.getSession();
            this.fViewModelAdapter = new GdbViewModelAdapter(session);
            this.fSourceDisplayAdapter = launch.getSourceLocator() instanceof ISourceLookupDirector ? new MISourceDisplayAdapter(session, (ISourceLookupDirector)launch.getSourceLocator()) : null;
            session.registerModelAdapter(ISourceDisplay.class, (Object)this.fSourceDisplayAdapter);
            this.fStepIntoCommand = new DsfStepIntoCommand(session);
            this.fStepOverCommand = new DsfStepOverCommand(session);
            this.fStepReturnCommand = new DsfStepReturnCommand(session);
            this.fSuspendCommand = new DsfSuspendCommand(session);
            this.fResumeCommand = new DsfResumeCommand(session);
            this.fTerminateCommand = new DsfTerminateCommand(session);
            this.fSuspendTrigger = new DsfSuspendTrigger(session, (ILaunch)this.fLaunch);
            session.registerModelAdapter(IStepIntoHandler.class, (Object)this.fStepIntoCommand);
            session.registerModelAdapter(IStepOverHandler.class, (Object)this.fStepOverCommand);
            session.registerModelAdapter(IStepReturnHandler.class, (Object)this.fStepReturnCommand);
            session.registerModelAdapter(ISuspendHandler.class, (Object)this.fSuspendCommand);
            session.registerModelAdapter(IResumeHandler.class, (Object)this.fResumeCommand);
            session.registerModelAdapter(ITerminateHandler.class, (Object)this.fTerminateCommand);
            this.fDebugModelProvider = new IDebugModelProvider(){

                public String[] getModelIdentifiers() {
                    return new String[]{"org.eclipse.dd.gdb"};
                }
            };
            session.registerModelAdapter(IDebugModelProvider.class, (Object)this.fDebugModelProvider);
            session.registerModelAdapter(ILaunch.class, (Object)this.fLaunch);
        }

        void dispose() {
            DsfSession session = this.fLaunch.getSession();
            this.fViewModelAdapter.dispose();
            session.unregisterModelAdapter(ISourceDisplay.class);
            if (this.fSourceDisplayAdapter != null) {
                this.fSourceDisplayAdapter.dispose();
            }
            session.unregisterModelAdapter(IStepIntoHandler.class);
            session.unregisterModelAdapter(IStepOverHandler.class);
            session.unregisterModelAdapter(IStepReturnHandler.class);
            session.unregisterModelAdapter(ISuspendHandler.class);
            session.unregisterModelAdapter(IResumeHandler.class);
            session.unregisterModelAdapter(ITerminateHandler.class);
            this.fStepIntoCommand.dispose();
            this.fStepOverCommand.dispose();
            this.fStepReturnCommand.dispose();
            this.fSuspendCommand.dispose();
            this.fResumeCommand.dispose();
            this.fTerminateCommand.dispose();
            this.fSuspendTrigger.dispose();
        }
    }
}

