/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.launching;

import java.util.Map;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchMessages;
import org.eclipse.dd.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.dd.gdb.internal.ui.launching.CLaunchConfigurationTab;
import org.eclipse.dd.gdb.internal.ui.launching.LaunchImages;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractCDebuggerTab
extends CLaunchConfigurationTab {
    protected ILaunchConfiguration fLaunchConfiguration;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected ICDebugConfiguration fCurrentDebugConfig;
    protected ICDebuggerPage fDynamicTab;
    protected Composite fDynamicTabHolder;
    private boolean fInitDefaults;
    private Combo fDCombo;
    private boolean fIsInitializing = false;
    private boolean fPageUpdated;

    protected void setDebugConfig(ICDebugConfiguration config) {
        this.fCurrentDebugConfig = config;
    }

    protected ICDebugConfiguration getDebugConfig() {
        return this.fCurrentDebugConfig;
    }

    protected ICDebuggerPage getDynamicTab() {
        return this.fDynamicTab;
    }

    protected void setDynamicTab(ICDebuggerPage tab) {
        this.fDynamicTab = tab;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
        this.setLaunchConfigurationWorkingCopy(null);
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    public String getErrorMessage() {
        ICDebuggerPage tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void handleDebuggerChanged() {
        this.loadDynamicDebugArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (wc != null) {
                wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_SPECIFIC_ATTRS_MAP", (Map)null);
            }
        } else {
            if (wc == null) {
                try {
                    if (this.getLaunchConfiguration().isWorkingCopy()) {
                        this.setLaunchConfigurationWorkingCopy((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration());
                    } else {
                        this.setLaunchConfigurationWorkingCopy(this.getLaunchConfiguration().getWorkingCopy());
                    }
                    wc = this.getLaunchConfigurationWorkingCopy();
                }
                catch (CoreException e) {
                    return;
                }
            }
            if (this.initDefaults()) {
                this.getDynamicTab().setDefaults(wc);
            }
            this.setInitializeDefault(false);
            this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
        }
    }

    protected void loadDynamicDebugArea() {
        Control[] children = this.getDynamicTabHolder().getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].dispose();
        }
        ICDebugConfiguration debugConfig = this.getConfigForCurrentDebugger();
        if (debugConfig == null) {
            this.setDynamicTab(null);
        } else {
            ICDebuggerPage tab = null;
            try {
                tab = CDebugUIPlugin.getDefault().getDebuggerPage(debugConfig.getID());
            }
            catch (CoreException e) {
                GdbUIPlugin.errorDialog(LaunchMessages.getString((String)"AbstractCDebuggerTab.ErrorLoadingDebuggerPage"), e.getStatus());
            }
            this.setDynamicTab(tab);
        }
        this.setDebugConfig(debugConfig);
        if (this.getDynamicTab() == null) {
            return;
        }
        this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        this.getDynamicTab().createControl(this.getDynamicTabHolder());
        this.getDynamicTab().getControl().setVisible(true);
        this.getDynamicTabHolder().layout(true);
        this.contentsChanged();
    }

    protected void contentsChanged() {
    }

    public abstract void createControl(Composite var1);

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        ICDebuggerPage dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.activated(workingCopy);
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setLaunchConfiguration(config);
        ICDebuggerPage dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.initializeFrom(config);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.getDebugConfig() != null) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", this.getDebugConfig().getID());
            ICDebuggerPage dynamicTab = this.getDynamicTab();
            if (dynamicTab == null) {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_SPECIFIC_ATTRS_MAP", (Map)null);
            } else {
                dynamicTab.performApply(config);
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.setLaunchConfigurationWorkingCopy(config);
        ICDebuggerPage dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.setDefaults(config);
            this.setInitializeDefault(false);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.getDebugConfig() == null) {
            this.setErrorMessage(LaunchMessages.getString((String)"AbstractCDebuggerTab.No_debugger_available"));
            return false;
        }
        ICDebuggerPage dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    protected void setInitializeDefault(boolean init) {
        this.fInitDefaults = init;
    }

    protected boolean initDefaults() {
        return this.fInitDefaults;
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_DEBUGGER_TAB);
    }

    public String getName() {
        return LaunchMessages.getString((String)"AbstractCDebuggerTab.Debugger");
    }

    protected void createDebuggerCombo(Composite parent, int colspan) {
        Composite comboComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comboComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colspan;
        comboComp.setLayoutData((Object)gd);
        Label dlabel = new Label(comboComp, 0);
        dlabel.setText(LaunchMessages.getString((String)"Launch.common.DebuggerColon"));
        this.fDCombo = new Combo(comboComp, 12);
        this.fDCombo.setLayoutData((Object)new GridData(768));
        this.fDCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!AbstractCDebuggerTab.this.isInitializing()) {
                    AbstractCDebuggerTab.this.setInitializeDefault(true);
                    AbstractCDebuggerTab.this.updateComboFromSelection();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void loadDebuggerCombo(ICDebugConfiguration[] debugConfigs, String current) {
        this.fDCombo.removeAll();
        int select = -1;
        for (int i = 0; i < debugConfigs.length; ++i) {
            this.fDCombo.add(debugConfigs[i].getName());
            this.fDCombo.setData(Integer.toString(i), (Object)debugConfigs[i]);
            if (!debugConfigs[i].getID().equalsIgnoreCase(current)) continue;
            select = i;
        }
        this.fPageUpdated = false;
        if (select != -1) {
            this.fDCombo.select(select);
        }
        if (!this.fPageUpdated) {
            this.updateComboFromSelection();
        }
        this.fPageUpdated = false;
        this.getControl().getParent().layout(true);
    }

    protected void createDebuggerGroup(Composite parent, int colspan) {
        Group debuggerGroup = new Group(parent, 16);
        debuggerGroup.setText(LaunchMessages.getString((String)"CDebuggerTab.Debugger_Options"));
        this.setDynamicTabHolder((Composite)debuggerGroup);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = colspan;
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void updateComboFromSelection() {
        this.fPageUpdated = true;
        this.handleDebuggerChanged();
        this.updateLaunchConfigurationDialog();
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    protected void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    protected ICDebugConfiguration getConfigForCurrentDebugger() {
        int selectedIndex = this.fDCombo.getSelectionIndex();
        return (ICDebugConfiguration)this.fDCombo.getData(Integer.toString(selectedIndex));
    }
}

