/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.viewmodel.launch;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.LaunchRootVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.StackFramesVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.StandardProcessVMNode;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.gdb.internal.ui.viewmodel.launch.ContainerVMNode;
import org.eclipse.dd.gdb.internal.ui.viewmodel.launch.ThreadVMNode;
import org.eclipse.dd.mi.service.command.MIInferiorProcess;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class LaunchVMProvider
extends AbstractDMVMProvider
implements IDebugEventSetListener,
ILaunchesListener2 {
    @ThreadSafe
    public LaunchVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);
        LaunchRootVMNode launchNode = new LaunchRootVMNode((AbstractVMProvider)this);
        this.setRootNode((IRootVMNode)launchNode);
        ContainerVMNode containerNode = new ContainerVMNode(this, this.getSession());
        StandardProcessVMNode processesNode = new StandardProcessVMNode((AbstractVMProvider)this);
        this.addChildNodes((IVMNode)launchNode, new IVMNode[]{containerNode, processesNode});
        ThreadVMNode threadsNode = new ThreadVMNode(this, this.getSession());
        this.addChildNodes((IVMNode)containerNode, new IVMNode[]{threadsNode});
        StackFramesVMNode stackFramesNode = new StackFramesVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)threadsNode, new IVMNode[]{stackFramesNode});
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void handleDebugEvents(final DebugEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    if (LaunchVMProvider.this.isDisposed()) {
                        return;
                    }
                    for (DebugEvent event : events) {
                        LaunchVMProvider.this.handleEvent(event);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        super.dispose();
    }

    public void launchesAdded(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.ADDED));
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.REMOVED));
    }

    public void launchesChanged(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.CHANGED));
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.TERMINATED));
    }

    private void handleLaunchesEvent(final LaunchRootVMNode.LaunchesEvent event) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    if (LaunchVMProvider.this.isDisposed()) {
                        return;
                    }
                    IRootVMNode rootLayoutNode = LaunchVMProvider.this.getRootVMNode();
                    if (rootLayoutNode != null && rootLayoutNode.getDeltaFlags((Object)event) != 0) {
                        LaunchVMProvider.this.handleEvent(event);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        IDMContext eventToSkipDmc;
        IDMContext newEventDmc;
        if (eventToSkip instanceof MIInferiorProcess.InferiorExitedDMEvent || eventToSkip instanceof MIInferiorProcess.InferiorStartedDMEvent || eventToSkip instanceof GDBControl.GDBStartedEvent || eventToSkip instanceof GDBControl.GDBExitedEvent) {
            return false;
        }
        return newEvent instanceof IRunControl.ISuspendedDMEvent && eventToSkip instanceof IDMEvent && ((newEventDmc = ((IDMEvent)newEvent).getDMContext()).equals(eventToSkipDmc = ((IDMEvent)eventToSkip).getDMContext()) || DMContexts.isAncestorOf((IDMContext)eventToSkipDmc, (IDMContext)newEventDmc));
    }
}

