/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.viewmodel.launch;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.gdb.internal.provisional.service.GDBRunControl;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadVMNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    private final String MEMENTO_NAME = "THREAD_MEMENTO_NAME";

    public ThreadVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IExecutionDMContext.class);
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IContainerDMContext.class);
        if (runControl == null || contDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        runControl.getExecutionContexts(contDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    ThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                ThreadVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    ThreadVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    public void getContextsForEvent(VMDelta parentDelta, Object e, final DataRequestMonitor<IVMContext[]> rm) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            IRunControl.IExecutionDMContext[] triggerContexts = ((IRunControl.IContainerResumedDMEvent)e).getTriggeringContexts();
            if (triggerContexts.length != 0) {
                rm.setData((Object)new IVMContext[]{this.createVMContext((IDMContext)triggerContexts[0])});
                rm.done();
                return;
            }
        } else if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            IRunControl.IExecutionDMContext[] triggerContexts = ((IRunControl.IContainerSuspendedDMEvent)e).getTriggeringContexts();
            if (triggerContexts.length != 0) {
                rm.setData((Object)new IVMContext[]{this.createVMContext((IDMContext)triggerContexts[0])});
                rm.done();
                return;
            }
        } else if (e instanceof ModelProxyInstalledEvent) {
            this.getThreadVMCForModelProxyInstallEvent(parentDelta, new DataRequestMonitor<VMContextInfo>(this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        rm.setData((Object)new IVMContext[]{((VMContextInfo)this.getData()).fVMContext});
                    } else {
                        rm.setData((Object)new IVMContext[0]);
                    }
                    rm.done();
                }
            });
            return;
        }
        super.getContextsForEvent(parentDelta, e, rm);
    }

    private void getThreadVMCForModelProxyInstallEvent(VMDelta parentDelta, final DataRequestMonitor<VMContextInfo> rm) {
        this.getVMProvider().updateNode((IVMNode)this, (IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            protected void handleSuccess() {
                try {
                    ThreadVMNode.this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            GDBRunControl runControl = (GDBRunControl)ThreadVMNode.this.getServicesTracker().getService(GDBRunControl.class);
                            if (runControl != null) {
                                int vmcIdx = -1;
                                int suspendedVmcIdx = -1;
                                for (int i = 0; i < ((List)this.getData()).size(); ++i) {
                                    IDMVMContext vmc;
                                    IRunControl.IExecutionDMContext execDmc;
                                    if (!(((List)this.getData()).get(i) instanceof IDMVMContext) || (execDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)(vmc = (IDMVMContext)((List)this.getData()).get(i)).getDMContext(), IRunControl.IExecutionDMContext.class)) == null) continue;
                                    int n = vmcIdx = vmcIdx < 0 ? i : vmcIdx;
                                    if (!runControl.isSuspended(execDmc)) continue;
                                    suspendedVmcIdx = suspendedVmcIdx < 0 ? i : suspendedVmcIdx;
                                }
                                if (suspendedVmcIdx >= 0) {
                                    rm.setData((Object)new VMContextInfo((IVMContext)((List)this.getData()).get(suspendedVmcIdx), suspendedVmcIdx, true));
                                } else if (vmcIdx >= 0) {
                                    rm.setData((Object)new VMContextInfo((IVMContext)((List)this.getData()).get(vmcIdx), vmcIdx, false));
                                } else {
                                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10004, "No threads available", null));
                                }
                                rm.done();
                            } else {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10004, "No threads available", null));
                                rm.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10003, "", null));
                    rm.done();
                }
            }
        }));
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            GDBRunControl runControl = (GDBRunControl)this.getServicesTracker().getService(GDBRunControl.class);
            if (runControl == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            final IMIExecutionDMContext dmc = (IMIExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IMIExecutionDMContext.class);
            String imageKey = null;
            imageKey = ((IRunControl)this.getServicesTracker().getService(IRunControl.class)).isSuspended((IRunControl.IExecutionDMContext)dmc) ? "IMG_OBJS_THREAD_SUSPENDED" : "IMG_OBJS_THREAD_RUNNING";
            update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
            runControl.getExecutionData((IRunControl.IExecutionDMContext)dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        ThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    GDBRunControl runControl = (GDBRunControl)ThreadVMNode.this.getServicesTracker().getService(GDBRunControl.class);
                    if (runControl == null) {
                        ThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    final IRunControl.StateChangeReason reason = ((IRunControl.IExecutionDMData)this.getData()).getStateChangeReason();
                    runControl.getThreadData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<GDBRunControl.GDBThreadData>((Executor)ThreadVMNode.this.getSession().getExecutor(), (IViewerUpdate)update){

                        public void handleCompleted() {
                            if (!this.isSuccess()) {
                                update.done();
                                return;
                            }
                            StringBuilder builder = new StringBuilder("Thread[");
                            builder.append(dmc.getThreadId());
                            builder.append("] ");
                            builder.append(((GDBRunControl.GDBThreadData)this.getData()).getId());
                            builder.append(((GDBRunControl.GDBThreadData)this.getData()).getName());
                            if (((IRunControl)ThreadVMNode.this.getServicesTracker().getService(IRunControl.class)).isSuspended((IRunControl.IExecutionDMContext)dmc)) {
                                builder.append(" (Suspended");
                            } else {
                                builder.append(" (Running");
                            }
                            if (reason != null) {
                                builder.append(" : ");
                                builder.append(reason);
                            }
                            builder.append(")");
                            update.setLabel(builder.toString(), 0);
                            update.done();
                        }
                    });
                }
            });
        }
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.IResumedDMEvent || e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof ModelProxyInstalledEvent) {
            return 0x300000;
        }
        return 0;
    }

    public void buildDelta(Object e, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor rm) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            IRunControl.IExecutionDMContext[] triggeringContexts = ((IRunControl.IContainerResumedDMEvent)e).getTriggeringContexts();
            if (triggeringContexts.length != 0) {
                parentDelta.addNode((Object)this.createVMContext((IDMContext)triggeringContexts[0]), 1024);
            }
            rm.done();
        } else if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            IRunControl.IExecutionDMContext[] triggeringContexts = ((IRunControl.IContainerSuspendedDMEvent)e).getTriggeringContexts();
            if (triggeringContexts.length != 0) {
                parentDelta.addNode((Object)this.createVMContext((IDMContext)triggeringContexts[0]), 1024);
            }
            rm.done();
        } else if (e instanceof IRunControl.IResumedDMEvent || e instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IDMEvent)e).getDMContext()), 1024);
            rm.done();
        } else if (e instanceof ModelProxyInstalledEvent) {
            this.getThreadVMCForModelProxyInstallEvent(parentDelta, new DataRequestMonitor<VMContextInfo>(this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        parentDelta.addNode((Object)((VMContextInfo)this.getData()).fVMContext, nodeOffset + ((VMContextInfo)this.getData()).fIndex, 0x100000 | (((VMContextInfo)this.getData()).fIsSuspended ? 0 : 0x200000));
                    }
                    rm.done();
                }
            });
        } else {
            rm.done();
        }
    }

    private String produceThreadElementName(String viewName, IMIExecutionDMContext execCtx) {
        return "Thread." + execCtx.getThreadId();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        for (IElementCompareRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString("THREAD_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IMIExecutionDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (IMIExecutionDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        for (IElementMementoRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IMIExecutionDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (IMIExecutionDMContext)dmc);
                memento.putString("THREAD_MEMENTO_NAME", elementName);
            }
            request.done();
        }
    }

    private static class VMContextInfo {
        final IVMContext fVMContext;
        final int fIndex;
        final boolean fIsSuspended;

        VMContextInfo(IVMContext vmContext, int index, boolean isSuspended) {
            this.fVMContext = vmContext;
            this.fIndex = index;
            this.fIsSuspended = isSuspended;
        }
    }
}

