/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.launching;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.mi.service.CSourceLookup;
import org.eclipse.dd.mi.service.MIBreakpointsManager;
import org.eclipse.dd.mi.service.command.commands.MIBreakInsert;
import org.eclipse.dd.mi.service.command.commands.MICommand;
import org.eclipse.dd.mi.service.command.commands.MIExecContinue;
import org.eclipse.dd.mi.service.command.commands.MIExecRun;
import org.eclipse.dd.mi.service.command.commands.MIFileExecFile;
import org.eclipse.dd.mi.service.command.commands.MIFileSymbolFile;
import org.eclipse.dd.mi.service.command.commands.MIGDBSetAutoSolib;
import org.eclipse.dd.mi.service.command.commands.MIGDBSetSolibSearchPath;
import org.eclipse.dd.mi.service.command.commands.MITargetSelect;
import org.eclipse.dd.mi.service.command.output.MIBreakInsertInfo;

public class FinalLaunchSequence
extends Sequence {
    Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), FinalLaunchSequence.this.fLaunch.getSession().getId());
            FinalLaunchSequence.this.fCommandControl = (GDBControl)((Object)tracker.getService(GDBControl.class));
            tracker.dispose();
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIFileExecFile(FinalLaunchSequence.this.fCommandControl.getControlDMContext(), FinalLaunchSequence.this.fCommandControl.getExecutablePath().toOSString()), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIFileSymbolFile(FinalLaunchSequence.this.fCommandControl.getControlDMContext(), FinalLaunchSequence.this.fCommandControl.getExecutablePath().toOSString()), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                boolean autolib = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIGDBSetAutoSolib(FinalLaunchSequence.this.fCommandControl.getControlDMContext(), autolib), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot set shared library option", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                List p = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, new ArrayList(1));
                if (p.size() > 0) {
                    String[] paths = p.toArray(new String[p.size()]);
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIGDBSetSolibSearchPath(FinalLaunchSequence.this.fCommandControl.getControlDMContext(), paths), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot set share library paths", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), FinalLaunchSequence.this.fLaunch.getSession().getId());
            CSourceLookup sourceLookup = (CSourceLookup)tracker.getService(CSourceLookup.class);
            tracker.dispose();
            CSourceLookupDirector locator = (CSourceLookupDirector)FinalLaunchSequence.this.fLaunch.getSourceLocator();
            sourceLookup.setSourceLookupPath((ISourceLookup.ISourceLookupDMContext)FinalLaunchSequence.this.fCommandControl.getGDBDMContext(), locator.getSourceContainers(), requestMonitor);
        }
    }, new Sequence.Step(){
        private boolean fTcpConnection;
        private String fRemoteTcpHost;
        private String fRemoteTcpPort;
        private String fSerialDevice;

        private boolean checkConnectionType(RequestMonitor requestMonitor) {
            try {
                this.fTcpConnection = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false);
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve connection mode", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getSerialDevice(RequestMonitor requestMonitor) {
            try {
                this.fSerialDevice = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve serial device", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getTcpHost(RequestMonitor requestMonitor) {
            try {
                this.fRemoteTcpHost = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve remote TCP host", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getTcpPort(RequestMonitor requestMonitor) {
            try {
                this.fRemoteTcpPort = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve remote TCP port", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        public void execute(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fSessionType == GDBControl.SessionType.REMOTE) {
                if (!this.checkConnectionType(requestMonitor)) {
                    return;
                }
                if (this.fTcpConnection) {
                    if (!this.getTcpHost(requestMonitor)) {
                        return;
                    }
                    if (!this.getTcpPort(requestMonitor)) {
                        return;
                    }
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MITargetSelect((IDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext(), this.fRemoteTcpHost, this.fRemoteTcpPort), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    if (!this.getSerialDevice(requestMonitor)) {
                        return;
                    }
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MITargetSelect((IDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext(), this.fSerialDevice), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                }
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), FinalLaunchSequence.this.fLaunch.getSession().getId());
            MIBreakpointsManager bpmService = (MIBreakpointsManager)tracker.getService(MIBreakpointsManager.class);
            tracker.dispose();
            bpmService.startTrackingBreakpoints((IBreakpoints.IBreakpointsTargetDMContext)FinalLaunchSequence.this.fCommandControl.getGDBDMContext(), requestMonitor);
        }
    }, new Sequence.Step(){
        private boolean fStopInMain = false;
        private String fStopSymbol = null;

        private boolean readStopAtMain(RequestMonitor requestMonitor) {
            try {
                this.fStopInMain = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve the entry point symbol", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean readStopSymbol(RequestMonitor requestMonitor) {
            try {
                this.fStopSymbol = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 5014, "Cannot retrieve the entry point symbol", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        public void execute(RequestMonitor requestMonitor) {
            Object execCommand = FinalLaunchSequence.this.fSessionType == GDBControl.SessionType.REMOTE ? new MIExecContinue((IRunControl.IExecutionDMContext)((IRunControl.IContainerDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext())) : new MIExecRun((IRunControl.IExecutionDMContext)((IRunControl.IContainerDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext()), new String[0]);
            if (!this.readStopAtMain(requestMonitor)) {
                return;
            }
            if (!this.fStopInMain) {
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)execCommand, new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            } else {
                if (!this.readStopSymbol(requestMonitor)) {
                    return;
                }
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIBreakInsert((IBreakpoints.IBreakpointsTargetDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext(), true, false, null, 0, this.fStopSymbol, 0), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor, (MICommand)execCommand, requestMonitor){
                    final /* synthetic */ MICommand val$execCommand;
                    final /* synthetic */ RequestMonitor val$requestMonitor;
                    {
                        this.val$execCommand = mICommand;
                        this.val$requestMonitor = requestMonitor;
                        super(x0, x1);
                    }

                    protected void handleSuccess() {
                        FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)this.val$execCommand, new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), this.val$requestMonitor));
                    }
                });
            }
        }
    }};
    GdbLaunch fLaunch;
    GDBControl.SessionType fSessionType;
    GDBControl fCommandControl;

    public FinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, GDBControl.SessionType type) {
        super(executor);
        this.fLaunch = launch;
        this.fSessionType = type;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }
}

