/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service.command;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.mi.service.command.AbstractCLIProcess;
import org.eclipse.dd.mi.service.command.AbstractMIControl;

class GDBCLIProcess
extends AbstractCLIProcess {
    public GDBCLIProcess(GDBControl commandControl, boolean useExecConsole) throws IOException {
        super((AbstractMIControl)commandControl, useExecConsole);
    }

    public int waitFor() throws InterruptedException {
        if (!DsfSession.isSessionActive((String)this.getSession().getId())) {
            return 0;
        }
        Process process = null;
        try {
            process = (Process)this.getSession().getExecutor().submit((Callable)new Callable<Process>(){

                @Override
                public Process call() throws Exception {
                    if (GDBCLIProcess.this.isDisposed()) {
                        return null;
                    }
                    return ((GDBControl)GDBCLIProcess.this.getCommandControl()).getGDBProcess();
                }
            }).get();
        }
        catch (RejectedExecutionException e) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (process == null) {
            return 0;
        }
        return process.waitFor();
    }

    public int exitValue() {
        block5: {
            if (!DsfSession.isSessionActive((String)this.getSession().getId())) {
                return 0;
            }
            try {
                return (Integer)this.getSession().getExecutor().submit((Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        if (!DsfSession.isSessionActive((String)GDBCLIProcess.this.getSession().getId())) {
                            return new Integer(-1);
                        }
                        if (GDBCLIProcess.this.isDisposed()) {
                            return new Integer(-1);
                        }
                        GDBControl gdb = (GDBControl)GDBCLIProcess.this.getCommandControl();
                        if (!gdb.isGDBExited()) {
                            throw new IllegalThreadStateException("GDB Process has not exited");
                        }
                        return gdb.getGDBExitCode();
                    }
                }).get();
            }
            catch (RejectedExecutionException e) {
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof RuntimeException)) break block5;
                throw (RuntimeException)e.getCause();
            }
        }
        return 0;
    }

    public void destroy() {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (!DsfSession.isSessionActive((String)GDBCLIProcess.this.getSession().getId())) {
                        return;
                    }
                    if (GDBCLIProcess.this.isDisposed()) {
                        return;
                    }
                    GDBControl gdb = (GDBControl)GDBCLIProcess.this.getCommandControl();
                    gdb.destroy();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

