/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBCLIProcess;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControlDMContext;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBInferiorProcess;
import org.eclipse.dd.mi.service.command.AbstractCLIProcess;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.CLIEventProcessor;
import org.eclipse.dd.mi.service.command.MIControlDMContext;
import org.eclipse.dd.mi.service.command.MIInferiorProcess;
import org.eclipse.dd.mi.service.command.MIRunControlEventProcessor;
import org.eclipse.dd.mi.service.command.commands.MIGDBExit;
import org.eclipse.dd.mi.service.command.commands.MIInterpreterExecConsole;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBControl
extends AbstractMIControl {
    private static int fgInstanceCounter = 0;
    private final GDBControlDMContext fControlDmc;
    private SessionType fSessionType;
    private boolean fConnected = false;
    private boolean fUseInterpreterConsole;
    private MonitorJob fMonitorJob;
    private IPath fGdbPath;
    private IPath fExecPath;
    private Process fProcess;
    private int fGDBExitValue;
    private final int fGDBLaunchTimeout;
    private MIRunControlEventProcessor fMIEventProcessor;
    private CLIEventProcessor fCLICommandProcessor;
    private AbstractCLIProcess fCLIProcess;
    private MIInferiorProcess fInferiorProcess;

    public GDBControl(DsfSession session, IPath gdbPath, IPath execPath, SessionType type, int gdbLaunchTimeout) {
        super(session);
        this.fSessionType = type;
        this.fGdbPath = gdbPath;
        this.fExecPath = execPath;
        this.fGDBLaunchTimeout = gdbLaunchTimeout;
        this.fControlDmc = new GDBControlDMContext(session.getId(), ((Object)((Object)this)).getClass().getName() + ":" + ++fgInstanceCounter);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBControl.this.doInitialize(requestMonitor);
            }
        });
    }

    public void doInitialize(RequestMonitor requestMonitor) {
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new GDBProcessStep(InitializationShutdownStep.Direction.INITIALIZING), new MonitorJobStep(InitializationShutdownStep.Direction.INITIALIZING), new CommandMonitoringStep(InitializationShutdownStep.Direction.INITIALIZING), new CheckInterpreterConsoleStep(InitializationShutdownStep.Direction.INITIALIZING), new CommandProcessorsStep(InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void shutdown(RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandProcessorsStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CheckInterpreterConsoleStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandMonitoringStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new MonitorJobStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new GDBProcessStep(InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence shutdownSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)shutdownSequence);
    }

    public MIControlDMContext getControlDMContext() {
        return this.fControlDmc;
    }

    public GDBControlDMContext getGDBDMContext() {
        return (GDBControlDMContext)this.getControlDMContext();
    }

    public SessionType getSessionType() {
        return this.fSessionType;
    }

    public boolean canInterrupt() {
        return this.fProcess instanceof Spawner;
    }

    public void interrupt() {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            gdbSpawner.interrupt();
        }
    }

    public void destroy() {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            gdbSpawner.destroy();
        }
    }

    public void terminate(final RequestMonitor rm) {
        final ScheduledFuture quitTimeoutFuture = this.getExecutor().schedule((Runnable)new DsfRunnable(){

            public void run() {
                if (!GDBControl.this.isGDBExited()) {
                    GDBControl.this.destroy();
                }
                rm.done();
            }

            protected boolean isExecutionRequired() {
                return false;
            }
        }, 2L, TimeUnit.SECONDS);
        MIGDBExit cmd = new MIGDBExit((IDMContext)this.fControlDmc);
        this.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleCompleted() {
                quitTimeoutFuture.cancel(false);
                if (!this.isSuccess() && !GDBControl.this.isGDBExited()) {
                    GDBControl.this.destroy();
                }
                rm.done();
            }
        });
    }

    public boolean isConnected() {
        return this.fInferiorProcess.getState() != MIInferiorProcess.State.TERMINATED && this.fConnected;
    }

    void setConnected(boolean connected) {
        this.fConnected = connected;
    }

    public Process getGDBProcess() {
        return this.fProcess;
    }

    public AbstractCLIProcess getCLIProcess() {
        return this.fCLIProcess;
    }

    public MIInferiorProcess getInferiorProcess() {
        return this.fInferiorProcess;
    }

    public boolean isGDBExited() {
        return this.fMonitorJob != null && this.fMonitorJob.fExited;
    }

    public int getGDBExitCode() {
        return this.fGDBExitValue;
    }

    public IPath getExecutablePath() {
        return this.fExecPath;
    }

    public void getInferiorProcessId(DataRequestMonitor<Integer> rm) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(ExitedEvent e) {
        this.stopCommandProcessing();
    }

    protected class CheckInterpreterConsoleStep
    extends InitializationShutdownStep {
        CheckInterpreterConsoleStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            MIInterpreterExecConsole cmd = new MIInterpreterExecConsole((IDMContext)GDBControl.this.fControlDmc, "echo");
            GDBControl.this.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)GDBControl.this.getExecutor(), null){

                protected void handleCompleted() {
                    GDBControl.this.fUseInterpreterConsole = this.isSuccess();
                    requestMonitor.done();
                }
            });
        }
    }

    protected class CommandMonitoringStep
    extends InitializationShutdownStep {
        CommandMonitoringStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        protected void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.startCommandProcessing(GDBControl.this.fProcess.getInputStream(), GDBControl.this.fProcess.getOutputStream());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.stopCommandProcessing();
            requestMonitor.done();
        }
    }

    protected class CommandProcessorsStep
    extends InitializationShutdownStep {
        CommandProcessorsStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            try {
                GDBControl.this.fCLIProcess = new GDBCLIProcess(GDBControl.this, GDBControl.this.fUseInterpreterConsole);
            }
            catch (IOException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10004, "Failed to create CLI Process", (Throwable)e));
                requestMonitor.done();
                return;
            }
            GDBControl.this.fInferiorProcess = new GDBInferiorProcess(GDBControl.this, GDBControl.this.fProcess.getOutputStream());
            GDBControl.this.fCLICommandProcessor = new CLIEventProcessor((AbstractMIControl)GDBControl.this, (IRunControl.IContainerDMContext)GDBControl.this.fControlDmc, GDBControl.this.fInferiorProcess);
            GDBControl.this.fMIEventProcessor = new MIRunControlEventProcessor((AbstractMIControl)GDBControl.this, (IRunControl.IContainerDMContext)GDBControl.this.fControlDmc);
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.fCLICommandProcessor.dispose();
            GDBControl.this.fMIEventProcessor.dispose();
            GDBControl.this.fCLIProcess.dispose();
            GDBControl.this.fInferiorProcess.dispose();
            requestMonitor.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExitedEvent
    extends AbstractDMEvent<GDBControlDMContext> {
        public ExitedEvent(GDBControlDMContext context) {
            super((IDMContext)context);
        }
    }

    protected class GDBProcessStep
    extends InitializationShutdownStep {
        GDBProcessStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            class GDBLaunchMonitor {
                boolean fLaunched = false;
                boolean fTimedOut = false;

                GDBLaunchMonitor() {
                }
            }
            final GDBLaunchMonitor fGDBLaunchMonitor = new GDBLaunchMonitor();
            final RequestMonitor gdbLaunchRequestMonitor = new RequestMonitor((Executor)GDBControl.this.getExecutor(), null){
                {
                    super(x0, x1);
                }

                protected void handleCompleted() {
                    if (!fGDBLaunchMonitor.fTimedOut) {
                        fGDBLaunchMonitor.fLaunched = true;
                        if (!this.isSuccess()) {
                            requestMonitor.setStatus(this.getStatus());
                        }
                        requestMonitor.done();
                    }
                }
            };
            final Job startGdbJob = new Job("Start GDB Process Job"){

                protected IStatus run(IProgressMonitor monitor) {
                    ArrayList<String> commandList = new ArrayList<String>();
                    commandList.add(GDBControl.this.fGdbPath.toOSString());
                    commandList.add("--interpreter");
                    commandList.add("mi");
                    String[] commandLine = commandList.toArray(new String[commandList.size()]);
                    try {
                        GDBControl.this.fProcess = ProcessFactory.getFactory().exec(commandLine);
                    }
                    catch (IOException e) {
                        String message = MessageFormat.format("Error while launching command", ((Object)commandList).toString());
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, message, (Throwable)e));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    try {
                        String line;
                        InputStream stream = GDBControl.this.fProcess.getInputStream();
                        InputStreamReader r = new InputStreamReader(stream);
                        BufferedReader reader = new BufferedReader(r);
                        while ((line = reader.readLine()) != null && !(line = line.trim()).endsWith("(gdb)")) {
                        }
                    }
                    catch (IOException e) {
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Error reading GDB STDOUT", (Throwable)e));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    gdbLaunchRequestMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            startGdbJob.schedule();
            GDBControl.this.getExecutor().schedule(new Runnable(){
                {
                }

                public void run() {
                    if (!fGDBLaunchMonitor.fLaunched) {
                        fGDBLaunchMonitor.fTimedOut = true;
                        Thread jobThread = startGdbJob.getThread();
                        if (jobThread != null) {
                            jobThread.interrupt();
                        }
                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 5010, "Timed out trying to launch GDB.", null));
                        requestMonitor.done();
                    }
                }
            }, (long)GDBControl.this.fGDBLaunchTimeout, TimeUnit.SECONDS);
        }

        protected void shutdown(final RequestMonitor requestMonitor) {
            new Job("Terminating GDB process."){

                protected IStatus run(IProgressMonitor monitor) {
                    GDBControl.this.fProcess.destroy();
                    for (int attempts = 0; attempts < 10; ++attempts) {
                        try {
                            GDBControl.this.fGDBExitValue = GDBControl.this.fProcess.exitValue();
                            requestMonitor.done();
                            return Status.OK_STATUS;
                        }
                        catch (IllegalThreadStateException ie) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10004, "Process terminate failed", null));
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public static class InitializationShutdownStep
    extends Sequence.Step {
        private Direction fDirection;

        InitializationShutdownStep(Direction direction) {
            this.fDirection = direction;
        }

        public final void execute(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.initialize(requestMonitor);
            } else {
                this.shutdown(requestMonitor);
            }
        }

        public final void rollBack(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.shutdown(requestMonitor);
            } else {
                super.rollBack(requestMonitor);
            }
        }

        protected void initialize(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Direction {
            INITIALIZING,
            SHUTTING_DOWN;

        }
    }

    private class MonitorJob
    extends Job {
        boolean fExited;
        DsfRunnable fMonitorStarted;
        Process fMonProcess;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Process process = this.fMonProcess;
            synchronized (process) {
                GDBControl.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                while (!this.fExited) {
                    try {
                        this.fMonProcess.waitFor();
                        GDBControl.this.fGDBExitValue = this.fMonProcess.exitValue();
                        this.fExited = true;
                    }
                    catch (InterruptedException ie) {
                        try {
                            Thread.interrupted();
                            this.fExited = true;
                        }
                        catch (Throwable throwable) {
                            this.fExited = true;
                            GDBControl.this.getSession().dispatchEvent((Object)new ExitedEvent(GDBControl.this.fControlDmc){}, GDBControl.this.getProperties());
                            throw throwable;
                        }
                        GDBControl.this.getSession().dispatchEvent((Object)new /* invalid duplicate definition of identical inner class */, GDBControl.this.getProperties());
                        continue;
                    }
                    GDBControl.this.getSession().dispatchEvent((Object)new /* invalid duplicate definition of identical inner class */, GDBControl.this.getProperties());
                }
            }
            return Status.OK_STATUS;
        }

        MonitorJob(Process process, DsfRunnable monitorStarted) {
            super("GDB process monitor job.");
            this.fExited = false;
            this.fMonProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fMonProcess;
            synchronized (process) {
                if (!this.fExited) {
                    this.getThread().interrupt();
                }
            }
        }
    }

    protected class MonitorJobStep
    extends InitializationShutdownStep {
        MonitorJobStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            GDBControl.this.fMonitorJob = new MonitorJob(GDBControl.this.fProcess, new DsfRunnable(){

                public void run() {
                    requestMonitor.done();
                }
            });
            GDBControl.this.fMonitorJob.schedule();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            if (!((GDBControl)GDBControl.this).fMonitorJob.fExited) {
                GDBControl.this.fMonitorJob.kill();
            }
            requestMonitor.done();
        }
    }

    protected class RegisterStep
    extends InitializationShutdownStep {
        RegisterStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.getSession().addServiceEventListener((Object)GDBControl.this, null);
            GDBControl.this.register(new String[]{ICommandControl.class.getName(), AbstractMIControl.class.getName()}, new Hashtable());
            GDBControl.this.getSession().dispatchEvent((Object)new StartedEvent(GDBControl.this.getGDBDMContext()), GDBControl.this.getProperties());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.unregister();
            GDBControl.this.getSession().removeServiceEventListener((Object)GDBControl.this);
            requestMonitor.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionType {
        RUN,
        ATTACH,
        CORE,
        REMOTE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartedEvent
    extends AbstractDMEvent<GDBControlDMContext> {
        public StartedEvent(GDBControlDMContext context) {
            super((IDMContext)context);
        }
    }
}

