/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.launching;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.IDsfService;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.service.GDBRunControl;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.mi.service.CSourceLookup;
import org.eclipse.dd.mi.service.ExpressionService;
import org.eclipse.dd.mi.service.MIBreakpoints;
import org.eclipse.dd.mi.service.MIBreakpointsManager;
import org.eclipse.dd.mi.service.MIDisassembly;
import org.eclipse.dd.mi.service.MIMemory;
import org.eclipse.dd.mi.service.MIModules;
import org.eclipse.dd.mi.service.MIRegisters;
import org.eclipse.dd.mi.service.MIStack;

public class ShutdownSequence
extends Sequence {
    String fSessionId;
    String fApplicationName;
    String fDebugModelId;
    DsfServicesTracker fTracker;
    private final Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            assert (GdbPlugin.getBundleContext() != null);
            ShutdownSequence.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), ShutdownSequence.this.fSessionId);
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIDisassembly.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIRegisters.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIBreakpointsManager.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIBreakpoints.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(CSourceLookup.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(ExpressionService.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIStack.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIModules.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIMemory.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(GDBRunControl.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(GDBControl.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }};

    public ShutdownSequence(DsfExecutor executor, String sessionId, RequestMonitor requestMonitor) {
        super(executor, requestMonitor);
        this.fSessionId = sessionId;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private void shutdownService(Class clazz, final RequestMonitor requestMonitor) {
        IDsfService service = (IDsfService)this.fTracker.getService(clazz);
        if (service != null) {
            service.shutdown(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        GdbPlugin.getDefault().getLog().log(this.getStatus());
                    }
                    requestMonitor.done();
                }
            });
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Service '" + clazz.getName() + "' not found.", null));
            requestMonitor.done();
        }
    }
}

