/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.launching;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchMessages;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.mi.service.CSourceLookup;
import org.eclipse.dd.mi.service.MIBreakpointsManager;
import org.eclipse.dd.mi.service.command.commands.CLIAttach;
import org.eclipse.dd.mi.service.command.commands.CLIMonitorListProcesses;
import org.eclipse.dd.mi.service.command.commands.CLISource;
import org.eclipse.dd.mi.service.command.commands.MIFileExecAndSymbols;
import org.eclipse.dd.mi.service.command.commands.MIGDBSetAutoSolib;
import org.eclipse.dd.mi.service.command.commands.MIGDBSetSolibSearchPath;
import org.eclipse.dd.mi.service.command.commands.MITargetSelect;
import org.eclipse.dd.mi.service.command.output.CLIMonitorListProcessesInfo;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;

public class FinalLaunchSequence
extends Sequence {
    Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), FinalLaunchSequence.this.fLaunch.getSession().getId());
            FinalLaunchSequence.this.fCommandControl = (GDBControl)((Object)tracker.getService(GDBControl.class));
            if (FinalLaunchSequence.this.fCommandControl == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot obtain GDBControl service", null));
            }
            tracker.dispose();
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            try {
                final String gdbinitFile = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.debug.mi.core.GDB_INIT", ".gdbinit");
                if (gdbinitFile != null && gdbinitFile.length() > 0) {
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new CLISource(FinalLaunchSequence.this.fCommandControl.getControlDMContext(), gdbinitFile), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleCompleted() {
                            if (!gdbinitFile.equals(".gdbinit")) {
                                requestMonitor.setStatus(this.getStatus());
                            }
                            requestMonitor.done();
                        }
                    });
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot get gdbinit option", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            IPath execPath = FinalLaunchSequence.this.fCommandControl.getExecutablePath();
            if (execPath != null && !execPath.isEmpty()) {
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIFileExecAndSymbols(FinalLaunchSequence.this.fCommandControl.getControlDMContext(), execPath.toOSString()), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                boolean autolib = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.debug.mi.core.AUTO_SOLIB", true);
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIGDBSetAutoSolib(FinalLaunchSequence.this.fCommandControl.getControlDMContext(), autolib), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot set shared library option", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                List p = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.debug.mi.core.SOLIB_PATH", new ArrayList(1));
                if (p.size() > 0) {
                    String[] paths = p.toArray(new String[p.size()]);
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIGDBSetSolibSearchPath(FinalLaunchSequence.this.fCommandControl.getControlDMContext(), paths), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot set share library paths", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), FinalLaunchSequence.this.fLaunch.getSession().getId());
            CSourceLookup sourceLookup = (CSourceLookup)tracker.getService(CSourceLookup.class);
            tracker.dispose();
            CSourceLookupDirector locator = (CSourceLookupDirector)FinalLaunchSequence.this.fLaunch.getSourceLocator();
            sourceLookup.setSourceLookupPath((ISourceLookup.ISourceLookupDMContext)FinalLaunchSequence.this.fCommandControl.getGDBDMContext(), locator.getSourceContainers(), requestMonitor);
        }
    }, new Sequence.Step(){
        private boolean fTcpConnection;
        private String fRemoteTcpHost;
        private String fRemoteTcpPort;
        private String fSerialDevice;

        private boolean checkConnectionType(RequestMonitor requestMonitor) {
            try {
                this.fTcpConnection = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.debug.mi.core.REMOTE_TCP", false);
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve connection mode", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getSerialDevice(RequestMonitor requestMonitor) {
            try {
                this.fSerialDevice = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.debug.mi.core.DEV", "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve serial device", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getTcpHost(RequestMonitor requestMonitor) {
            try {
                this.fRemoteTcpHost = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.debug.mi.core.HOST", "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve remote TCP host", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getTcpPort(RequestMonitor requestMonitor) {
            try {
                this.fRemoteTcpPort = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.debug.mi.core.PORT", "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve remote TCP port", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        public void execute(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fSessionType == GDBControl.SessionType.REMOTE) {
                if (!this.checkConnectionType(requestMonitor)) {
                    return;
                }
                if (this.fTcpConnection) {
                    if (!this.getTcpHost(requestMonitor)) {
                        return;
                    }
                    if (!this.getTcpPort(requestMonitor)) {
                        return;
                    }
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MITargetSelect((IDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext(), this.fRemoteTcpHost, this.fRemoteTcpPort), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    if (!this.getSerialDevice(requestMonitor)) {
                        return;
                    }
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MITargetSelect((IDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext(), this.fSerialDevice), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                }
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void promptForProcessID(ILaunchConfiguration config, DataRequestMonitor<Integer> rm) {
            Status promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
            Status processPromptStatus = new Status(1, "org.eclipse.dd.gdb.ui", 100, "", null);
            final IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)promptStatus);
            Status noPidStatus = new Status(4, "org.eclipse.dd.gdb", -1, LaunchMessages.getString("LocalAttachLaunchDelegate.No_Process_ID_selected"), null);
            if (prompter == null) {
                rm.setStatus((IStatus)noPidStatus);
                rm.done();
                return;
            }
            final Job promptForPid = new Job("Prompt for Process", (IStatus)processPromptStatus, rm, noPidStatus){
                final /* synthetic */ IStatus val$processPromptStatus;
                final /* synthetic */ DataRequestMonitor val$rm;
                final /* synthetic */ Status val$noPidStatus;
                {
                    this.val$processPromptStatus = iStatus;
                    this.val$rm = dataRequestMonitor;
                    this.val$noPidStatus = status;
                    super(x0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Object result = prompter.handleStatus(this.val$processPromptStatus, (Object)FinalLaunchSequence.this);
                        if (result instanceof Integer) {
                            this.val$rm.setData((Object)((Integer)result));
                        } else {
                            this.val$rm.setStatus((IStatus)this.val$noPidStatus);
                        }
                    }
                    catch (CoreException e) {
                        this.val$rm.setStatus((IStatus)this.val$noPidStatus);
                    }
                    this.val$rm.done();
                    return Status.OK_STATUS;
                }
            };
            if (FinalLaunchSequence.this.fSessionType == GDBControl.SessionType.LOCAL) {
                try {
                    IProcessList list = CCorePlugin.getDefault().getProcessList();
                    if (list == null) return;
                    FinalLaunchSequence.this.fProcessList = list.getProcessList();
                    return;
                }
                catch (CoreException e) {
                    return;
                }
                finally {
                    promptForPid.schedule();
                }
            } else {
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new CLIMonitorListProcesses((IDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext()), (DataRequestMonitor)new DataRequestMonitor<CLIMonitorListProcessesInfo>((Executor)FinalLaunchSequence.this.getExecutor(), rm){

                    protected void handleCompleted() {
                        FinalLaunchSequence.this.fProcessList = this.isSuccess() ? ((CLIMonitorListProcessesInfo)this.getData()).getProcessList() : new IProcessInfo[0];
                        promptForPid.schedule();
                    }
                });
            }
        }

        public void execute(final RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fAttach) {
                int pid = -1;
                try {
                    pid = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (pid != -1) {
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new CLIAttach((IDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext(), pid), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    this.promptForProcessID(FinalLaunchSequence.this.fLaunch.getLaunchConfiguration(), new DataRequestMonitor<Integer>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleSuccess() {
                            FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new CLIAttach((IDMContext)FinalLaunchSequence.this.fCommandControl.getControlDMContext(), ((Integer)this.getData()).intValue()), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                        }
                    });
                }
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), FinalLaunchSequence.this.fLaunch.getSession().getId());
            MIBreakpointsManager bpmService = (MIBreakpointsManager)tracker.getService(MIBreakpointsManager.class);
            tracker.dispose();
            bpmService.startTrackingBreakpoints((IBreakpoints.IBreakpointsTargetDMContext)FinalLaunchSequence.this.fCommandControl.getGDBDMContext(), requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fCommandControl.start(FinalLaunchSequence.this.fLaunch, requestMonitor);
        }
    }};
    GdbLaunch fLaunch;
    GDBControl.SessionType fSessionType;
    boolean fAttach;
    GDBControl fCommandControl;
    IProcessInfo[] fProcessList = null;

    public FinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, GDBControl.SessionType sessionType, boolean attach) {
        super(executor);
        this.fLaunch = launch;
        this.fSessionType = sessionType;
        this.fAttach = attach;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    public IProcessInfo[] getProcessList() {
        return this.fProcessList;
    }
}

