/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.launching;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchMessages;
import org.eclipse.dd.gdb.internal.provisional.service.SessionType;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class LaunchUtils {
    public static ICProject verifyCProject(ILaunchConfiguration configuration) throws CoreException {
        String name = LaunchUtils.getProjectName(configuration);
        if (name == null) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.C_Project_not_specified"), null, 102);
            return null;
        }
        ICProject cproject = LaunchUtils.getCProject(configuration);
        if (cproject == null && name.length() > 0) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!proj.exists()) {
                LaunchUtils.abort(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Project_NAME_does_not_exist", name), null, 103);
            } else if (!proj.isOpen()) {
                LaunchUtils.abort(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Project_NAME_is_closed", name), null, 103);
            }
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Not_a_C_CPP_project"), null, 103);
        }
        return cproject;
    }

    public static IPath verifyProgramPath(ILaunchConfiguration configuration, ICProject cproject) throws CoreException {
        Path programPath;
        String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", (String)null);
        if (programName == null) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_not_specified"), null, 103);
        }
        if ((programPath = new Path(programName)).isEmpty()) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_does_not_exist"), null, 103);
        }
        if (!programPath.isAbsolute() && cproject != null) {
            IFile wsProgramPath = cproject.getProject().getFile((IPath)programPath);
            programPath = wsProgramPath.getLocation();
        }
        if (!programPath.toFile().exists()) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.PROGRAM_PATH_not_found", programPath.toOSString())), 104);
        }
        return programPath;
    }

    public static IBinaryParser.IBinaryObject verifyBinary(ILaunchConfiguration configuration, IPath exePath) throws CoreException {
        ICExtensionReference[] parserRefs;
        for (ICExtensionReference parserRef : parserRefs = CCorePlugin.getDefault().getBinaryParserExtensions(LaunchUtils.getCProject(configuration).getProject())) {
            try {
                IBinaryParser parser = (IBinaryParser)parserRef.createExtension();
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                if (exe == null) continue;
                return exe;
            }
            catch (ClassCastException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            return (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
        }
        catch (ClassCastException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_is_not_a_recognized_executable"), new FileNotFoundException(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Program_is_not_a_recognized_executable", exePath.toOSString())), 107);
        return null;
    }

    private static void abort(String message, Throwable exception, int code) throws CoreException {
        MultiStatus status = new MultiStatus("org.eclipse.dd.gdb", code, message, exception);
        status.add((IStatus)new Status(4, "org.eclipse.dd.gdb", code, exception == null ? "" : exception.getLocalizedMessage(), exception));
        throw new CoreException((IStatus)status);
    }

    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = LaunchUtils.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    private static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", (String)null);
    }

    public static IPath getGDBPath(ILaunchConfiguration configuration) {
        Path retVal = new Path("gdb");
        try {
            retVal = new Path(configuration.getAttribute("org.eclipse.dd.gdb.DEBUG_NAME", "gdb"));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return retVal;
    }

    public static String getGDBVersion(ILaunchConfiguration configuration) throws CoreException {
        String version = "";
        Process process = null;
        String cmd = LaunchUtils.getGDBPath(configuration).toOSString() + " --version";
        try {
            process = ProcessFactory.getFactory().exec(cmd);
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.gdb", 5012, "Error while launching command: " + cmd, e.getCause()));
        }
        try {
            String line;
            InputStream stream = process.getInputStream();
            InputStreamReader r = new InputStreamReader(stream);
            BufferedReader reader = new BufferedReader(r);
            Pattern pattern = Pattern.compile(" gdb( \\(.*\\))? (\\d*(\\.\\d*)*)", 8);
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                version = matcher.group(2);
            }
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.gdb", 5012, "Error reading GDB STDOUT after sending: " + cmd, e.getCause()));
        }
        return version;
    }

    public static boolean getIsAttach(ILaunchConfiguration config) {
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("run")) {
                return false;
            }
            if (debugMode.equals("attach")) {
                return true;
            }
            if (debugMode.equals("core")) {
                return false;
            }
            if (debugMode.equals("remote")) {
                return false;
            }
            if (debugMode.equals("remote_attach")) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public static SessionType getSessionType(ILaunchConfiguration config) {
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("run")) {
                return SessionType.LOCAL;
            }
            if (debugMode.equals("attach")) {
                return SessionType.LOCAL;
            }
            if (debugMode.equals("core")) {
                return SessionType.CORE;
            }
            if (debugMode.equals("remote")) {
                return SessionType.REMOTE;
            }
            if (debugMode.equals("remote_attach")) {
                return SessionType.REMOTE;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return SessionType.LOCAL;
    }

    public static boolean getConsoleVerboseMode(ILaunchConfiguration config) {
        boolean verboseMode = false;
        try {
            verboseMode = config.getAttribute("org.eclipse.dd.gdb.verboseMode", false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return verboseMode;
    }
}

