/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CheckVlnv {
    private static HashMap<String, String> referenceTypes = new HashMap();

    public static int checkVlnv(DocumentChecker checker) {
        FileDetails fileDetails;
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        Vlnv vlnv = theDoc.getVlnv();
        if (vlnv == null) {
            ++nErrors;
            checker.getReporter().report(CheckList.CHECK_1, theDoc, Messages.CheckVlnv_20);
        }
        if ((fileDetails = checker.getLibrary().getFileDetailsForVlnv(vlnv)) != null && fileDetails.getDuplicates() != null) {
            ++nErrors;
            checker.getReporter().report(CheckList.CHECK_1, theDoc, Messages.CheckVlnv_21);
        }
        return nErrors;
    }

    public static int checkLinkTypes(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//@spirit:vendor/..");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            SpiritDocument linkedDoc = null;
            try {
                linkedDoc = checker.getLinkedDocument(node);
            }
            catch (Exception e) {
                checker.getReporter().report(CheckList.CHECK_2, theDoc, e.getMessage(), node);
                ++nErrors;
                continue;
            }
            String linkedType = linkedDoc.getRootTagName();
            String thisType = node.getLocalName();
            String expectedReferenceType = referenceTypes.get(thisType);
            if (expectedReferenceType == null) {
                checker.getReporter().report(CheckList.CHECKS_3_11, theDoc, MessageFormat.format(Messages.CheckVlnv_23, thisType), node);
                ++nErrors;
                continue;
            }
            if (expectedReferenceType.equals(linkedType)) continue;
            checker.getReporter().report(CheckList.CHECKS_3_11, theDoc, MessageFormat.format(Messages.CheckVlnv_24, thisType, linkedType, expectedReferenceType), node);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkFileRefs(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        NodeList nodes = checker.getNodes(checker.getSpiritDocument().getDocumentElement(), "//spirit:file");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node fileNode = nodes.item(i);
            String name = checker.getName(fileNode);
            File resourceLocation = checker.getFilePathResolver().resolveFilePath(name, fileNode);
            if (resourceLocation != null) continue;
            checker.getReporter().report(CheckList.CHECK_76, theDoc, MessageFormat.format(Messages.CheckVlnv_26, name), fileNode);
            ++nErrors;
        }
        return nErrors;
    }

    static {
        referenceTypes.put("busType", "busDefinition");
        referenceTypes.put("extends", "busDefinition");
        referenceTypes.put("designRef", "design");
        referenceTypes.put("pmdRef", "pmd");
        referenceTypes.put("generatorChainRef", "generatorChain");
        referenceTypes.put("owner", "component");
        referenceTypes.put("fileName", "generatorChain");
        referenceTypes.put("busDefinitionFile", "busDefinition");
        referenceTypes.put("componentRef", "component");
        referenceTypes.put("hierarchyRef", "design");
    }
}

