/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.object.BusInterface;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CheckMonitorInterfaces {
    public static int checkMonitorConnections(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        XPath evaluator = checker.getXpathEvaluator();
        HashMap<String, BusInterface> activeBusInterfaceMap = new HashMap<String, BusInterface>();
        HashMap<String, BusInterface> monitorBusInterfaceMap = new HashMap<String, BusInterface>();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:monitorInterconnection");
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            Node interconnectionNode = nodes.item(index);
            Node activeInterfaceNode = checker.getNode(interconnectionNode, "spirit:activeInterface");
            Element activeBusInterfaceNode = Utilities.getBusInterfaceForActiveInterface(checker, activeInterfaceNode);
            if (activeBusInterfaceNode == null) continue;
            BusInterface activeBusInterface = new BusInterface(evaluator, activeBusInterfaceNode);
            activeBusInterface.setContext(evaluator.evaluate("@spirit:componentRef", activeInterfaceNode));
            String activeInterfaceType = activeBusInterface.getType();
            String systemGroup = null;
            if (activeBusInterface.isSystem() || activeBusInterface.isMirroredSystem()) {
                systemGroup = activeBusInterface.getSystemGroup();
            }
            if (activeBusInterfaceMap.put(activeBusInterface.toString(), activeBusInterface) != null) {
                reporter.report(CheckList.CHECK_36, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_3, activeBusInterface), interconnectionNode);
                ++nErrors;
            }
            ArrayList<BusInterface> monitorBusInterfaces = new ArrayList<BusInterface>();
            NodeList monitorInterfaceNodes = checker.getNodes(interconnectionNode, "spirit:monitorInterface");
            for (int mIndex = 0; mIndex < monitorInterfaceNodes.getLength(); ++mIndex) {
                Node monitorInterfaceNode = monitorInterfaceNodes.item(mIndex);
                Element monitorBusInterfaceNode = Utilities.getBusInterfaceForActiveInterface(checker, monitorInterfaceNode);
                if (monitorBusInterfaceNode == null) continue;
                BusInterface monitorBusInterface = new BusInterface(evaluator, monitorBusInterfaceNode);
                monitorBusInterface.setContext(evaluator.evaluate("@spirit:componentRef", monitorInterfaceNode));
                monitorBusInterfaces.add(monitorBusInterface);
                if (monitorBusInterfaceMap.put(monitorBusInterface.toString(), monitorBusInterface) == null) continue;
                reporter.report(CheckList.CHECK_36, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_6, monitorBusInterface), interconnectionNode);
                ++nErrors;
            }
            if (monitorBusInterfaces.isEmpty()) {
                reporter.report(CheckList.CHECK_WARNING, theDoc, Messages.CheckMonitorInterfaces_7, interconnectionNode);
                ++nErrors;
                continue;
            }
            if (activeBusInterface.isMonitor()) {
                reporter.report(CheckList.CHECK_32, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_8, activeBusInterface, activeInterfaceType), interconnectionNode);
                ++nErrors;
            }
            for (BusInterface monitorBusInterface : monitorBusInterfaces) {
                String monitorInterfaceType;
                if (!monitorBusInterface.isMonitor()) {
                    reporter.report(CheckList.CHECK_33, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_9, monitorBusInterface), interconnectionNode);
                    ++nErrors;
                }
                if (!activeInterfaceType.equals(monitorInterfaceType = monitorBusInterface.getMonitorInterfaceType())) {
                    reporter.report(CheckList.CHECK_34, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_10, monitorBusInterface, monitorInterfaceType, activeInterfaceType), interconnectionNode);
                    ++nErrors;
                }
                String monitorGroup = monitorBusInterface.getSystemGroup();
                if (systemGroup == null || systemGroup.equals(monitorGroup)) continue;
                reporter.report(CheckList.CHECK_35, theDoc, MessageFormat.format(Messages.CheckMonitorInterfaces_11, monitorBusInterface, monitorGroup, systemGroup), interconnectionNode);
                ++nErrors;
            }
        }
        return nErrors;
    }
}

