/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;

public class Check61Visitor
extends CheckVisitor {
    private static final String DEFAULT_CONNECTION_TYPE = "explicit";
    private static final String CONNECTION_TYPE_DEFAULTED = Messages.Check61Visitor_Default;

    public Check61Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) {
        String fromDefaulted = "";
        String connectionType = hierarchicalConnection.busInterface.getConnectionType();
        if (connectionType.length() == 0) {
            connectionType = DEFAULT_CONNECTION_TYPE;
            fromDefaulted = CONNECTION_TYPE_DEFAULTED;
        }
        String toDefaulted = "";
        String refConnectionType = hierarchicalConnection.refBusInterface.getConnectionType();
        if (refConnectionType.length() == 0) {
            refConnectionType = DEFAULT_CONNECTION_TYPE;
            toDefaulted = CONNECTION_TYPE_DEFAULTED;
        }
        String message = Messages.Check61Visitor_0;
        if (!connectionType.equals(refConnectionType)) {
            this.reporter.report(CheckList.CHECK_61, null, MessageFormat.format(message, fromDefaulted, connectionType, hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv(), toDefaulted, refConnectionType, hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
            ++this.problems;
        }
        return true;
    }
}

