/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.checker.core.object.SignalName;

public class Check64Visitor
extends CheckVisitor {
    public Check64Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) throws XPathExpressionException {
        List<SignalName> signalMap = hierarchicalConnection.busInterface.getSignalMap();
        List<SignalName> refSignalMap = hierarchicalConnection.refBusInterface.getSignalMap();
        boolean hasSignalMap = signalMap != null;
        boolean refHasSignalMap = refSignalMap != null;
        String message = Messages.Check64Visitor_0;
        if (!hasSignalMap == refHasSignalMap) {
            this.reporter.report(CheckList.CHECK_64, null, MessageFormat.format(message, this.getPresence(hasSignalMap), hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv(), this.getPresence(refHasSignalMap), hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
            ++this.problems;
        }
        return true;
    }

    private String getPresence(boolean hasSignalMap) {
        return hasSignalMap ? Messages.Check64Visitor_Present : Messages.Check64Visitor_Absent;
    }
}

