/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.HierachicalComponentNode;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.checker.core.models.ListingVisitor;
import org.eclipse.dd.ipxact.checker.core.object.BusInterface;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierachyModel {
    private final HierachicalComponentNode componentHierarchyRoot = new HierachicalComponentNode(null);
    private final List<List<HierarchicalConnection>> hierarchicalConnectionChains = new ArrayList<List<HierarchicalConnection>>();

    public int buildModel(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ArrayList<HierarchicalConnection> hierarchicalConnections = new ArrayList<HierarchicalConnection>();
        nErrors += this.getHierarchicalBusInterfaces(checker, theDoc, hierarchicalConnections);
        if (!hierarchicalConnections.isEmpty()) {
            HierachicalComponentNode hierachicalComponentNode = new HierachicalComponentNode(theDoc);
            this.componentHierarchyRoot.add(hierachicalComponentNode);
            for (HierarchicalConnection hierarchicalConnection : hierarchicalConnections) {
                ArrayList<HierarchicalConnection> chain = new ArrayList<HierarchicalConnection>();
                chain.add(hierarchicalConnection);
                this.hierarchicalConnectionChains.add(chain);
                nErrors += this.followHierarchicalConnection(checker, hierarchicalConnection, chain, hierachicalComponentNode);
            }
        }
        return nErrors;
    }

    private int followHierarchicalConnection(DocumentChecker checker, HierarchicalConnection hierarchicalConnection, List<HierarchicalConnection> chain, HierachicalComponentNode hierachicalComponentNode) throws XPathExpressionException {
        int nErrors = 0;
        HierachicalComponentNode refHierachicalComponentNode = new HierachicalComponentNode(hierarchicalConnection.refBusInterfaceDoc);
        hierachicalComponentNode.add(refHierachicalComponentNode);
        ArrayList<HierarchicalConnection> hierarchicalConnections = new ArrayList<HierarchicalConnection>();
        nErrors += this.getHierarchicalBusInterfaces(checker, hierarchicalConnection.refBusInterfaceDoc, hierarchicalConnections);
        if (!hierarchicalConnections.isEmpty()) {
            Vlnv vlnv = hierarchicalConnection.refBusInterfaceDoc.getVlnv();
            String busInterfaceName = hierarchicalConnection.refBusInterface.getName();
            for (HierarchicalConnection refHierarchicalConnection : hierarchicalConnections) {
                if (!vlnv.equals((Object)refHierarchicalConnection.busInterfaceDoc.getVlnv()) || !busInterfaceName.equals(refHierarchicalConnection.busInterface.getName())) continue;
                chain.add(refHierarchicalConnection);
                nErrors += this.followHierarchicalConnection(checker, refHierarchicalConnection, chain, refHierachicalComponentNode);
                break;
            }
        }
        return nErrors;
    }

    private int getHierarchicalBusInterfaces(DocumentChecker checker, SpiritDocument componentDoc, List<HierarchicalConnection> hierarchicalConnections) throws XPathExpressionException {
        if (!(componentDoc instanceof SpiritComponentDocument)) {
            throw new IllegalArgumentException("HierachyModel.getHierarchicalBusInterfaces(): Document is not a component");
        }
        int nErrors = 0;
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        XPath evaluator = checker.getXpathEvaluator();
        HashSet<String> busInterfaces = new HashSet<String>();
        NodeList hierarchyRefList = checker.getNodes(componentDoc.getDocumentElement(), "//spirit:hierarchyRef");
        for (int hrIndex = 0; hrIndex < hierarchyRefList.getLength(); ++hrIndex) {
            Node hierarchyRefNode = hierarchyRefList.item(hrIndex);
            Vlnv designVlnv = checker.getVlnvRef(hierarchyRefNode);
            SpiritDocument designDoc = library.get(designVlnv);
            if (designDoc == null) continue;
            NodeList hierarchicalConnectionList = checker.getNodes(designDoc.getDocumentElement(), "//spirit:hierConnection");
            for (int hcIndex = 0; hcIndex < hierarchicalConnectionList.getLength(); ++hcIndex) {
                Node hierarchicalConnectionNode = hierarchicalConnectionList.item(hcIndex);
                String busInterfaceName = evaluator.evaluate("@spirit:interfaceName", hierarchicalConnectionNode).trim();
                if (!busInterfaces.add(busInterfaceName)) {
                    reporter.report(CheckList.CHECK_ERROR, componentDoc, MessageFormat.format(Messages.HierachyModel_3, busInterfaceName, componentDoc.getVlnv(), designVlnv));
                    ++nErrors;
                    continue;
                }
                Node busInterfaceNode = Utilities.getBusInterface(checker, componentDoc.getBaseDocument(), busInterfaceName);
                if (busInterfaceNode == null) {
                    reporter.report(CheckList.CHECK_WARNING, componentDoc, MessageFormat.format(Messages.HierachyModel_4, designVlnv, busInterfaceName, componentDoc.getVlnv()));
                    ++nErrors;
                    continue;
                }
                SpiritDocument refComponentDoc = Utilities.getComponentDocumentForHierConnection(checker, hierarchicalConnectionNode);
                if (refComponentDoc == null) {
                    String componentInstanceName = evaluator.evaluate("spirit:componentRef", hierarchicalConnectionNode).trim();
                    reporter.report(CheckList.CHECK_ERROR, componentDoc, MessageFormat.format(Messages.HierachyModel_6, designVlnv, componentInstanceName));
                    ++nErrors;
                    continue;
                }
                String refBusInterfaceName = evaluator.evaluate("spirit:interfaceRef", hierarchicalConnectionNode).trim();
                Node refBusInterfaceNode = Utilities.getBusInterface(checker, refComponentDoc.getBaseDocument(), refBusInterfaceName);
                if (refBusInterfaceNode == null) {
                    reporter.report(CheckList.CHECK_ERROR, componentDoc, MessageFormat.format(Messages.HierachyModel_8, designVlnv, refBusInterfaceName, refComponentDoc.getVlnv()));
                    ++nErrors;
                    continue;
                }
                BusInterface busInterface = new BusInterface(evaluator, busInterfaceNode);
                BusInterface refBusInterface = new BusInterface(evaluator, refBusInterfaceNode);
                HierarchicalConnection hierarchicalConnection = new HierarchicalConnection(busInterface, componentDoc, refBusInterface, refComponentDoc);
                hierarchicalConnections.add(hierarchicalConnection);
            }
        }
        return nErrors;
    }

    public HierachicalComponentNode getComponentHierarchyRoot() {
        return this.componentHierarchyRoot;
    }

    public List<List<HierarchicalConnection>> getHierarchicalConnectionChains() {
        return this.hierarchicalConnectionChains;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Bus Interfaces:\n");
        for (List<HierarchicalConnection> chain : this.hierarchicalConnectionChains) {
            sb.append(chain);
            sb.append('\n');
        }
        ListingVisitor listingVisitor = new ListingVisitor("Components:");
        this.componentHierarchyRoot.accept(listingVisitor);
        sb.append(listingVisitor.getListing());
        return sb.toString();
    }
}

