/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import org.eclipse.dd.ipxact.checker.core.utils.Decode;

class MemoryRange {
    private final long start;
    private final long range;

    public MemoryRange(String start, String range) throws NumberFormatException {
        this.start = Decode.decode(start);
        this.range = Decode.decode(range);
    }

    public MemoryRange(long start, long range) {
        this.start = start;
        this.range = range;
    }

    public long getStart() {
        return this.start;
    }

    public long getRange() {
        return this.range;
    }

    public long getExtent() {
        return this.start + this.range;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[0x");
        sb.append(Long.toHexString(this.start));
        sb.append(",0x");
        sb.append(Long.toHexString(this.range));
        sb.append(']');
        return sb.toString();
    }
}

