/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.checker.core.object.SignalName;

public class Check66Visitor
extends CheckVisitor {
    public Check66Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) throws XPathExpressionException {
        Map<String, SignalName> signalNames = hierarchicalConnection.busInterface.getSignalNames();
        Map<String, SignalName> refSignalNames = hierarchicalConnection.refBusInterface.getSignalNames();
        if (signalNames != null && refSignalNames != null) {
            String message = Messages.Check66Visitor_0;
            for (Map.Entry<String, SignalName> entry : signalNames.entrySet()) {
                String refValue;
                String busSignalName = entry.getKey();
                SignalName refSignalName = refSignalNames.get(busSignalName);
                if (refSignalName == null) continue;
                String value = entry.getValue().getLeft();
                if (!value.equals(refValue = refSignalName.getLeft())) {
                    this.reporter.report(CheckList.CHECK_66, null, MessageFormat.format(message, "left", hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv(), hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv(), busSignalName));
                    ++this.problems;
                }
                if ((value = entry.getValue().getRight()).equals(refValue = refSignalName.getRight())) continue;
                this.reporter.report(CheckList.CHECK_66, null, MessageFormat.format(message, "right", hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv(), hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv(), busSignalName));
                ++this.problems;
            }
        }
        return true;
    }
}

