/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.checker.core.object.ComponentSignal;
import org.eclipse.dd.ipxact.checker.core.object.SignalName;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;

public class Check67Visitor
extends CheckVisitor {
    public Check67Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) throws XPathExpressionException {
        String message = Messages.Check67Visitor_0;
        Map<String, SignalName> signalNames = hierarchicalConnection.busInterface.getSignalNames();
        Map<String, SignalName> refSignalNames = hierarchicalConnection.refBusInterface.getSignalNames();
        if (signalNames != null && refSignalNames != null) {
            Map<String, ComponentSignal> componentSignals = Utilities.getComponentSignals(hierarchicalConnection.busInterfaceDoc);
            Map<String, ComponentSignal> refComponentSignals = Utilities.getComponentSignals(hierarchicalConnection.refBusInterfaceDoc);
            for (SignalName signalName : signalNames.values()) {
                String refDirection;
                String direction;
                String componentSignalName = signalName.getName();
                ComponentSignal componentSignal = componentSignals.get(componentSignalName);
                ComponentSignal refComponentSignal = refComponentSignals.get(componentSignalName);
                if (componentSignal == null || refComponentSignal == null || (direction = componentSignal.getDirection()).equals(refDirection = refComponentSignal.getDirection())) continue;
                this.reporter.report(CheckList.CHECK_67, null, MessageFormat.format(message, direction, componentSignal, hierarchicalConnection.busInterfaceDoc.getVlnv(), refDirection, refComponentSignal, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
                ++this.problems;
            }
        }
        return true;
    }
}

